/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.containers.ContainersFactory;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.parser.JaMoPPParserAPI;
import tools.mdsd.jamopp.parser.injection.ConverterModule;
import tools.mdsd.jamopp.parser.injection.FactoryModule;
import tools.mdsd.jamopp.parser.injection.HelperModule;
import tools.mdsd.jamopp.parser.injection.JamoppModule;
import tools.mdsd.jamopp.parser.injection.ResolverModule;
import tools.mdsd.jamopp.parser.injection.VisitorModule;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppClasspathEntriesSearcher;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppCompilationUnitsFactory;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppFileWithJDTParser;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppJavaParserFactory;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;
import tools.mdsd.jamopp.parser.interfaces.visitor.AbstractVisitor;

public class JaMoPPJDTParser
implements JaMoPPParserAPI {
    public static final String DEFAULT_ENCODING;
    public static final String DEFAULT_JAVA_VERSION;
    private static final Logger LOGGER;
    private static final AbstractVisitor VISITOR;
    private static final ContainersFactory CONTAINERS_FACTORY;
    private static final JamoppClasspathEntriesSearcher JAMOPP_CLASSPATH_ENTRIES_SEARCHER;
    private static final JamoppCompilationUnitsFactory JAMOPP_COMPILATION_UNITS_FACTORY;
    private static final JamoppFileWithJDTParser JAMOPP_FILE_WITH_JDT_PARSER;
    private static final JamoppJavaParserFactory JAMOPP_JAVA_PARSER_FACTORY;
    private static final JdtResolver UTIL_JDT_RESOLVER;
    private static final UtilTypeInstructionSeparation UTIL_TYPE_INSTRUCTION_SEPARATION;
    private ResourceSet resourceSet;

    static {
        Injector injector = Guice.createInjector((Module[])new Module[]{new HelperModule(), new FactoryModule(), new ConverterModule(), new VisitorModule(), new JamoppModule(JaMoPPJDTParser.class.getSimpleName()), new ResolverModule()});
        DEFAULT_ENCODING = (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"DEFAULT_ENCODING")));
        DEFAULT_JAVA_VERSION = (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"DEFAULT_JAVA_VERSION")));
        VISITOR = (AbstractVisitor)((Object)injector.getInstance(AbstractVisitor.class));
        UTIL_JDT_RESOLVER = (JdtResolver)injector.getInstance(JdtResolver.class);
        UTIL_TYPE_INSTRUCTION_SEPARATION = (UtilTypeInstructionSeparation)injector.getInstance(UtilTypeInstructionSeparation.class);
        CONTAINERS_FACTORY = (ContainersFactory)injector.getInstance(ContainersFactory.class);
        LOGGER = (Logger)injector.getInstance(Logger.class);
        JAMOPP_CLASSPATH_ENTRIES_SEARCHER = (JamoppClasspathEntriesSearcher)injector.getInstance(JamoppClasspathEntriesSearcher.class);
        JAMOPP_COMPILATION_UNITS_FACTORY = (JamoppCompilationUnitsFactory)injector.getInstance(JamoppCompilationUnitsFactory.class);
        JAMOPP_JAVA_PARSER_FACTORY = (JamoppJavaParserFactory)injector.getInstance(JamoppJavaParserFactory.class);
        JAMOPP_FILE_WITH_JDT_PARSER = (JamoppFileWithJDTParser)injector.getInstance(JamoppFileWithJDTParser.class);
    }

    public JaMoPPJDTParser() {
        CONTAINERS_FACTORY.createEmptyModel();
        this.resourceSet = new ResourceSetImpl();
        UTIL_JDT_RESOLVER.setResourceSet(this.resourceSet);
    }

    @Override
    public List<JavaRoot> convertCompilationUnits(Map<String, CompilationUnit> compilationUnits) {
        ArrayList<JavaRoot> result = new ArrayList<JavaRoot>();
        for (Map.Entry<String, CompilationUnit> entry : compilationUnits.entrySet()) {
            String sourceFilePath = entry.getKey();
            entry.getValue().accept((ASTVisitor)VISITOR);
            JavaRoot root = VISITOR.getConvertedElement();
            if (root.eResource() == null) {
                newResource = this.resourceSet.createResource(URI.createFileURI((String)sourceFilePath));
                newResource.getContents().add((Object)root);
            } else {
                newResource = root.eResource();
                if (!newResource.getURI().toFileString().equals(sourceFilePath)) {
                    newResource.setURI(URI.createFileURI((String)sourceFilePath));
                }
            }
            result.add(root);
        }
        UTIL_TYPE_INSTRUCTION_SEPARATION.convertAll();
        UTIL_JDT_RESOLVER.completeResolution();
        for (Resource res : new ArrayList(this.resourceSet.getResources())) {
            if (!res.getContents().isEmpty()) continue;
            try {
                res.delete(this.resourceSet.getLoadOptions());
            }
            catch (IOException e) {
                LOGGER.error((Object)res.getURI(), (Throwable)e);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean returnValue;
        if (this == obj) {
            returnValue = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            returnValue = false;
        } else {
            JaMoPPJDTParser other = (JaMoPPJDTParser)obj;
            returnValue = Objects.equals(this.resourceSet, other.resourceSet);
        }
        return returnValue;
    }

    @Override
    public <T> Set<T> get(Class<T> type) {
        return this.resourceSet.getResources().stream().filter(Objects::nonNull).filter(r -> !r.getContents().isEmpty() && !"file".equals(r.getURI().scheme())).map(r -> (EObject)r.getContents().get(0)).filter(Objects::nonNull).filter(type::isInstance).map(type::cast).collect(Collectors.toSet());
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public String[] getSourcepathEntries(Path dir) {
        String[] returnValue;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
                returnValue = (String[])paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(this::isJavaFile).map(Path::toAbsolutePath).map(Path::normalize).map(Path::toString).filter(p -> {
                    Resource resource = JavaClasspath.get().getResource(URI.createFileURI((String)p));
                    if (resource != null) {
                        this.resourceSet.getResources().add((Object)resource);
                        return false;
                    }
                    return true;
                }).toArray(String[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)dir, (Throwable)e);
            returnValue = new String[]{};
        }
        return returnValue;
    }

    private boolean isJavaFile(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().toLowerCase(Locale.US).endsWith("java");
    }

    public int hashCode() {
        return Objects.hash(this.resourceSet);
    }

    @Override
    public JavaRoot parse(String fileName, InputStream input) {
        JavaRoot root;
        Resource resource = JavaClasspath.get().getResource(URI.createFileURI((String)fileName));
        if (resource != null) {
            root = (JavaRoot)resource.getContents().get(0);
        } else {
            StringBuilder builder = new StringBuilder();
            String lineSep = System.lineSeparator();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (BufferedReader buffReader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                    buffReader.lines().forEach(line -> {
                        StringBuilder stringBuilder2 = builder.append((String)line).append(lineSep);
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)input, (Throwable)e);
            }
            String src = builder.toString();
            ASTNode ast = JAMOPP_FILE_WITH_JDT_PARSER.parseFileWithJDT(src, fileName);
            VISITOR.setSource(src);
            ast.accept((ASTVisitor)VISITOR);
            UTIL_TYPE_INSTRUCTION_SEPARATION.convertAll();
            UTIL_JDT_RESOLVER.completeResolution();
            root = VISITOR.getConvertedElement();
        }
        return root;
    }

    @Override
    public ResourceSet parseDirectory(ASTParser parser, Path dir) {
        String[] sources = this.getSourcepathEntries(dir);
        Object[] encodings = new String[sources.length];
        Arrays.fill(encodings, DEFAULT_ENCODING);
        this.convertCompilationUnits(JaMoPPJDTParser.getCompilationUnits(parser, JaMoPPJDTParser.getClasspathEntries(dir), sources, (String[])encodings));
        return this.resourceSet;
    }

    @Override
    public ResourceSet parseDirectory(Path dir) {
        return this.parseDirectory(JaMoPPJDTParser.getJavaParser(DEFAULT_JAVA_VERSION), dir);
    }

    @Override
    public Resource parseFile(Path file) {
        Resource result = JavaClasspath.get().getResource(URI.createFileURI((String)file.toAbsolutePath().toString()));
        if (result == null) {
            result = this.convertCompilationUnits(JaMoPPJDTParser.getCompilationUnits(JaMoPPJDTParser.getJavaParser(DEFAULT_JAVA_VERSION), new String[0], new String[]{file.toAbsolutePath().toString()}, new String[]{DEFAULT_ENCODING})).get(0).eResource();
        }
        return result;
    }

    @Override
    public ResourceSet parsePackage(IPackageFragment javaPackage) {
        ConcurrentHashMap<String, CompilationUnit> compilationUnits = new ConcurrentHashMap<String, CompilationUnit>();
        try {
            ICompilationUnit[] iCompilationUnitArray = javaPackage.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n2];
                if (unit instanceof CompilationUnit) {
                    compilationUnits.put(unit.getPath().toString(), (CompilationUnit)unit);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)javaPackage, (Throwable)e);
        }
        this.convertCompilationUnits(compilationUnits);
        return this.resourceSet;
    }

    @Override
    public ResourceSet parseProject(IJavaProject javaProject) {
        ConcurrentHashMap<String, CompilationUnit> compilationUnits = new ConcurrentHashMap<String, CompilationUnit>();
        try {
            IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment mypackage = iPackageFragmentArray[n2];
                ICompilationUnit[] iCompilationUnitArray = mypackage.getCompilationUnits();
                int n3 = iCompilationUnitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICompilationUnit unit = iCompilationUnitArray[n4];
                    if (unit instanceof CompilationUnit) {
                        compilationUnits.put(unit.getPath().toString(), (CompilationUnit)unit);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.error((Object)javaProject, (Throwable)e);
        }
        this.convertCompilationUnits(compilationUnits);
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(ResourceSet set) {
        this.resourceSet = Objects.requireNonNull(set);
    }

    public String toString() {
        return "JaMoPPJDTParser [resourceSet=" + this.resourceSet + "]";
    }

    public static String[] getClasspathEntries(Path dir) {
        return JAMOPP_CLASSPATH_ENTRIES_SEARCHER.getClasspathEntries(dir);
    }

    public static Map<String, CompilationUnit> getCompilationUnits(ASTParser parser, String[] classpathEntries, String[] sources, String[] encodings) {
        return JAMOPP_COMPILATION_UNITS_FACTORY.getCompilationUnits(parser, classpathEntries, sources, encodings);
    }

    public static ASTParser getJavaParser(String version) {
        return JAMOPP_JAVA_PARSER_FACTORY.getJavaParser(version);
    }
}

