/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToConcreteClassifierConverterWithExtraInfo;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingInfoToConcreteClassifierConverterImpl
implements ToConcreteClassifierConverterWithExtraInfo {
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtTResolverUtility;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;
    private final Converter<IVariableBinding, EnumConstant> bindingToEnumConstantConverter;
    private final Converter<IMethodBinding, Method> bindingToMethodConverter;
    private final Converter<IMethodBinding, Constructor> bindingToConstructorConverter;
    private final Converter<IVariableBinding, Field> bindingToFieldConverter;
    private final Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private final Converter<Integer, Collection<Modifier>> toModifiersConverter;

    @Inject
    public BindingInfoToConcreteClassifierConverterImpl(UtilNamedElement utilNamedElement, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<Integer, Collection<Modifier>> toModifiersConverter, JdtResolver jdtTResolverUtility, Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter, Converter<IMethodBinding, Method> bindingToMethodConverter, Converter<IVariableBinding, Field> bindingToFieldConverter, Converter<IVariableBinding, EnumConstant> bindingToEnumConstantConverter, Converter<IMethodBinding, Constructor> bindingToConstructorConverter, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.utilNamedElement = utilNamedElement;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToEnumConstantConverter = bindingToEnumConstantConverter;
        this.bindingToMethodConverter = bindingToMethodConverter;
        this.bindingToConstructorConverter = bindingToConstructorConverter;
        this.bindingToFieldConverter = bindingToFieldConverter;
        this.bindingToTypeParameterConverter = bindingToTypeParameterConverter;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.toModifiersConverter = toModifiersConverter;
    }

    @Override
    public ConcreteClassifier convert(ITypeBinding binding, boolean extractAdditionalInformation) {
        ITypeBinding typeDeclaration = binding.getTypeDeclaration();
        ConcreteClassifier result = this.getConcreteClassifier(typeDeclaration, extractAdditionalInformation);
        result.setPackage(this.jdtTResolverUtility.getPackage(typeDeclaration.getPackage()));
        if (result.eContainer() == null) {
            this.handleEmptyContainer(typeDeclaration, extractAdditionalInformation, result);
        }
        if (extractAdditionalInformation) {
            this.extractAdditionalInformation(typeDeclaration, result);
        }
        return result;
    }

    private void handleEmptyContainer(ITypeBinding binding, boolean extractAdditionalInformation, ConcreteClassifier result) {
        if (extractAdditionalInformation) {
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    result.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                    ++n2;
                }
                iAnnotationBindingArray = binding.getTypeParameters();
                n = iAnnotationBindingArray.length;
                n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding typeBind = iAnnotationBindingArray[n2];
                    result.getTypeParameters().add((Object)this.bindingToTypeParameterConverter.convert((ITypeBinding)typeBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        result.getAnnotationsAndModifiers().addAll(this.toModifiersConverter.convert(binding.getModifiers()));
        this.utilNamedElement.convertToNameAndSet(binding, (NamedElement)result);
    }

    private void extractAdditionalInformation(ITypeBinding binding, ConcreteClassifier result) {
        try {
            this.addFields(binding, result);
            this.addMethods(binding, result);
            this.addTypes(binding, result);
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    private void addTypes(ITypeBinding binding, ConcreteClassifier result) {
        ITypeBinding[] iTypeBindingArray = binding.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeBind = iTypeBindingArray[n2];
            ConcreteClassifier member = this.convert(typeBind, true);
            if (!result.getMembers().contains((Object)member)) {
                result.getMembers().add((Object)member);
            }
            ++n2;
        }
    }

    private void addFields(ITypeBinding binding, ConcreteClassifier result) {
        IVariableBinding[] iVariableBindingArray = binding.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding varBind = iVariableBindingArray[n2];
            if (!varBind.isEnumConstant()) {
                Member member = (Member)this.bindingToFieldConverter.convert(varBind);
                if (!result.getMembers().contains((Object)member)) {
                    result.getMembers().add((Object)member);
                }
            }
            ++n2;
        }
    }

    private void addMethods(ITypeBinding binding, ConcreteClassifier result) {
        IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methBind = iMethodBindingArray[n2];
            if (!methBind.isDefaultConstructor()) {
                Member member = methBind.isConstructor() ? (Member)this.bindingToConstructorConverter.convert(methBind) : (Member)this.bindingToMethodConverter.convert(methBind);
                if (!result.getMembers().contains((Object)member)) {
                    result.getMembers().add((Object)member);
                }
            }
            ++n2;
        }
    }

    private ConcreteClassifier getConcreteClassifier(ITypeBinding binding, boolean extractAdditionalInformation) {
        Object result = binding.isAnnotation() ? this.jdtTResolverUtility.getAnnotation(binding) : (binding.isClass() ? this.handleClass(binding) : (binding.isInterface() ? this.handleInterface(binding) : this.handleElse(binding, extractAdditionalInformation)));
        return result;
    }

    private ConcreteClassifier handleElse(ITypeBinding binding, boolean extractAdditionalInformation) {
        Enumeration resultEnum = this.jdtTResolverUtility.getEnumeration(binding);
        if (resultEnum.eContainer() == null) {
            try {
                ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeBind = iTypeBindingArray[n2];
                    resultEnum.getImplements().addAll((Collection)this.toTypeReferencesConverter.convert(typeBind));
                    ++n2;
                }
                if (extractAdditionalInformation) {
                    iTypeBindingArray = binding.getDeclaredFields();
                    n = iTypeBindingArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        ITypeBinding varBind = iTypeBindingArray[n2];
                        if (varBind.isEnumConstant()) {
                            resultEnum.getConstants().add((Object)this.bindingToEnumConstantConverter.convert((IVariableBinding)varBind));
                        }
                        ++n2;
                    }
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        return resultEnum;
    }

    private ConcreteClassifier handleInterface(ITypeBinding binding) {
        Interface resultInterface = this.jdtTResolverUtility.getInterface(binding);
        if (resultInterface.eContainer() == null) {
            try {
                ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeBind = iTypeBindingArray[n2];
                    resultInterface.getExtends().addAll((Collection)this.toTypeReferencesConverter.convert(typeBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        return resultInterface;
    }

    private ConcreteClassifier handleClass(ITypeBinding binding) {
        Class resultClass = this.jdtTResolverUtility.getClass(binding);
        if (resultClass.eContainer() == null) {
            try {
                if (binding.getSuperclass() != null) {
                    resultClass.setExtends(this.toTypeReferencesConverter.convert(binding.getSuperclass()).get(0));
                }
                ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding typeBind = iTypeBindingArray[n2];
                    resultClass.getImplements().addAll((Collection)this.toTypeReferencesConverter.convert(typeBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        return resultClass;
    }
}

