/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameter;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameterList;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsFactory;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToAnnotationInstanceConverter
implements Converter<IAnnotationBinding, AnnotationInstance> {
    private final AnnotationsFactory annotationsFactory;
    private final UtilNamedElement utilNamedElement;
    private final Provider<JdtResolver> jdtTResolverUtility;
    private final Provider<Converter<IMemberValuePairBinding, AnnotationAttributeSetting>> bindingToAnnotationAttributeSettingConverter;

    @Inject
    public BindingToAnnotationInstanceConverter(UtilNamedElement utilNamedElement, AnnotationsFactory annotationsFactory, Provider<JdtResolver> jdtTResolverUtility, Provider<Converter<IMemberValuePairBinding, AnnotationAttributeSetting>> bindingToAnnotationAttributeSettingConverter) {
        this.annotationsFactory = annotationsFactory;
        this.utilNamedElement = utilNamedElement;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationAttributeSettingConverter = bindingToAnnotationAttributeSettingConverter;
    }

    @Override
    public AnnotationInstance convert(IAnnotationBinding binding) {
        AnnotationInstance result = this.annotationsFactory.createAnnotationInstance();
        Annotation resultClass = ((JdtResolver)this.jdtTResolverUtility.get()).getAnnotation(binding.getAnnotationType());
        this.utilNamedElement.convertToNameAndSet(binding.getAnnotationType(), (NamedElement)resultClass);
        result.setAnnotation((Classifier)resultClass);
        if (binding.getDeclaredMemberValuePairs().length > 0) {
            AnnotationParameterList params = this.annotationsFactory.createAnnotationParameterList();
            IMemberValuePairBinding[] iMemberValuePairBindingArray = binding.getDeclaredMemberValuePairs();
            int n = iMemberValuePairBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding memBind = iMemberValuePairBindingArray[n2];
                params.getSettings().add((Object)((AnnotationAttributeSetting)((Converter)this.bindingToAnnotationAttributeSettingConverter.get()).convert(memBind)));
                ++n2;
            }
            result.setParameter((AnnotationParameter)params);
        }
        return result;
    }
}

