/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilArrays;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToConstructorConverter
implements Converter<IMethodBinding, Constructor> {
    private final LiteralsFactory literalsFactory;
    private final ParametersFactory parametersFactory;
    private final JdtResolver jdtTResolverUtility;
    private final UtilArrays utilJdtBindingConverter;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private final Converter<ITypeBinding, NamespaceClassifierReference> bindingToNamespaceClassifierReferenceConverter;
    private final Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter;
    private final Converter<Integer, Collection<Modifier>> toModifiersConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;

    @Inject
    public BindingToConstructorConverter(UtilArrays utilJdtBindingConverter, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<Integer, Collection<Modifier>> toModifiersConverter, ParametersFactory parametersFactory, LiteralsFactory literalsFactory, JdtResolver jdtTResolverUtility, Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter, Converter<ITypeBinding, NamespaceClassifierReference> bindingToNamespaceClassifierReferenceConverter, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.literalsFactory = literalsFactory;
        this.parametersFactory = parametersFactory;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.bindingToNamespaceClassifierReferenceConverter = bindingToNamespaceClassifierReferenceConverter;
        this.utilJdtBindingConverter = utilJdtBindingConverter;
        this.bindingToTypeParameterConverter = bindingToTypeParameterConverter;
        this.toModifiersConverter = toModifiersConverter;
    }

    @Override
    public Constructor convert(IMethodBinding binding) {
        Constructor result = this.jdtTResolverUtility.getConstructor(binding);
        if (result.eContainer() == null) {
            this.addAnnotationsAndModifiers(binding, result);
            result.setName(binding.getName());
            this.addTypeParameters(binding, result);
            this.addParameters(binding, result);
            this.addExceptions(binding, result);
        }
        return result;
    }

    private void addExceptions(IMethodBinding binding, Constructor result) {
        ITypeBinding[] iTypeBindingArray = binding.getExceptionTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeBind = iTypeBindingArray[n2];
            result.getExceptions().add((Object)this.bindingToNamespaceClassifierReferenceConverter.convert(typeBind));
            ++n2;
        }
    }

    private void addParameters(IMethodBinding binding, Constructor result) {
        if (binding.getDeclaredReceiverType() != null) {
            ReceiverParameter param = this.parametersFactory.createReceiverParameter();
            param.setName("");
            param.setTypeReference(this.toTypeReferencesConverter.convert(binding.getDeclaredReceiverType()).get(0));
            param.setOuterTypeReference(param.getTypeReference());
            param.setThisReference(this.literalsFactory.createThis());
            result.getParameters().add((Object)param);
        }
        int index = 0;
        while (index < binding.getParameterTypes().length) {
            ITypeBinding typeBind = binding.getParameterTypes()[index];
            Object param = binding.isVarargs() && index == binding.getParameterTypes().length - 1 ? this.parametersFactory.createVariableLengthParameter() : this.parametersFactory.createOrdinaryParameter();
            param.setName("param" + index);
            param.setTypeReference(this.toTypeReferencesConverter.convert(typeBind).get(0));
            this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(typeBind, (ArrayTypeable)param);
            IAnnotationBinding[] binds = binding.getParameterAnnotations(index);
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binds;
                int n = binds.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    param.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.getParameters().add(param);
            ++index;
        }
    }

    private void addTypeParameters(IMethodBinding binding, Constructor result) {
        try {
            ITypeBinding[] iTypeBindingArray = binding.getTypeParameters();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeBind = iTypeBindingArray[n2];
                result.getTypeParameters().add((Object)this.bindingToTypeParameterConverter.convert(typeBind));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    private void addAnnotationsAndModifiers(IMethodBinding binding, Constructor result) {
        result.getAnnotationsAndModifiers().addAll(this.toModifiersConverter.convert(binding.getModifiers()));
        try {
            IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
            int n = iAnnotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                result.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }
}

