/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToEnumConstantConverter
implements Converter<IVariableBinding, EnumConstant> {
    private final JdtResolver iUtilJdtResolver;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;

    @Inject
    public BindingToEnumConstantConverter(JdtResolver iUtilJdtResolver, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
    }

    @Override
    public EnumConstant convert(IVariableBinding binding) {
        EnumConstant result = this.iUtilJdtResolver.getEnumConstant(binding);
        if (result.eContainer() == null) {
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    result.getAnnotations().add((Object)this.bindingToAnnotationInstanceConverter.convert(annotBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.setName(binding.getName());
        }
        return result;
    }
}

