/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilArrays;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToFieldConverter
implements Converter<IVariableBinding, Field> {
    private final JdtResolver jdtTResolverUtility;
    private final UtilArrays utilJdtBindingConverter;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private final Converter<Object, PrimaryExpression> objectToPrimaryExpressionConverter;
    private final Converter<Integer, Collection<Modifier>> toModifiersConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;

    @Inject
    public BindingToFieldConverter(UtilArrays utilJdtBindingConverter, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<Integer, Collection<Modifier>> toModifiersConverter, Converter<Object, PrimaryExpression> objectToPrimaryExpressionConverter, JdtResolver jdtTResolverUtility, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.utilJdtBindingConverter = utilJdtBindingConverter;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.objectToPrimaryExpressionConverter = objectToPrimaryExpressionConverter;
        this.toModifiersConverter = toModifiersConverter;
    }

    @Override
    public Field convert(IVariableBinding binding) {
        Field result;
        ReferenceableElement refElement = this.jdtTResolverUtility.getReferencableElement(binding);
        if (refElement.eContainer() != null) {
            result = refElement instanceof AdditionalField ? (Field)((AdditionalField)refElement).eContainer() : (Field)refElement;
        } else {
            result = (Field)refElement;
            result.getAnnotationsAndModifiers().addAll(this.toModifiersConverter.convert(binding.getModifiers()));
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    result.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.setName(binding.getName());
            result.setTypeReference(this.toTypeReferencesConverter.convert(binding.getType()).get(0));
            this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(binding.getType(), (ArrayTypeable)result);
            if (binding.getConstantValue() != null) {
                result.setInitialValue((Expression)this.objectToPrimaryExpressionConverter.convert(binding.getConstantValue()));
            }
        }
        return result;
    }
}

