/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToInternalReferenceConverter
implements Converter<ITypeBinding, Reference> {
    private final ReferencesFactory referencesFactory;
    private final JdtResolver jdtTResolverUtility;

    @Inject
    public BindingToInternalReferenceConverter(ReferencesFactory referencesFactory, JdtResolver jdtTResolverUtility) {
        this.referencesFactory = referencesFactory;
        this.jdtTResolverUtility = jdtTResolverUtility;
    }

    @Override
    public Reference convert(ITypeBinding binding) {
        IdentifierReference idRef = this.referencesFactory.createIdentifierReference();
        idRef.setTarget((ReferenceableElement)this.jdtTResolverUtility.getClassifier(binding));
        if (binding.isNested()) {
            Reference parentRef = this.convert(binding.getDeclaringClass());
            parentRef.setNext((Reference)idRef);
        }
        return idRef;
    }
}

