/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.modifiers.Default;
import tools.mdsd.jamopp.model.java.modifiers.Modifier;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilArrays;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToMethodConverter
implements Converter<IMethodBinding, Method> {
    private final StatementsFactory statementsFactory;
    private final LiteralsFactory literalsFactory;
    private final ParametersFactory parametersFactory;
    private final JdtResolver jdtTResolverUtility;
    private final UtilArrays utilJdtBindingConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;
    private final Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private final Converter<Object, AnnotationValue> objectToAnnotationValueConverter;
    private final Converter<ITypeBinding, NamespaceClassifierReference> bindingToNamespaceClassifierReferenceConverter;
    private final Converter<Integer, Collection<Modifier>> toModifiersConverter;

    @Inject
    public BindingToMethodConverter(UtilArrays utilJdtBindingConverter, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<Integer, Collection<Modifier>> toModifiersConverter, StatementsFactory statementsFactory, ParametersFactory parametersFactory, Converter<Object, AnnotationValue> objectToAnnotationValueConverter, LiteralsFactory literalsFactory, JdtResolver jdtTResolverUtility, Converter<ITypeBinding, TypeParameter> bindingToTypeParameterConverter, Converter<ITypeBinding, NamespaceClassifierReference> bindingToNamespaceClassifierReferenceConverter, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.statementsFactory = statementsFactory;
        this.literalsFactory = literalsFactory;
        this.parametersFactory = parametersFactory;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.utilJdtBindingConverter = utilJdtBindingConverter;
        this.bindingToTypeParameterConverter = bindingToTypeParameterConverter;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.objectToAnnotationValueConverter = objectToAnnotationValueConverter;
        this.bindingToNamespaceClassifierReferenceConverter = bindingToNamespaceClassifierReferenceConverter;
        this.toModifiersConverter = toModifiersConverter;
    }

    @Override
    public Method convert(IMethodBinding binding) {
        Method result = this.jdtTResolverUtility.getMethod(binding);
        if (result.eContainer() == null) {
            this.addAnnotationsAndModifiers(binding, result);
            result.setName(binding.getName());
            result.setTypeReference(this.toTypeReferencesConverter.convert(binding.getReturnType()).get(0));
            this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(binding.getReturnType(), (ArrayTypeable)result);
            this.addTypeParamters(binding, result);
            this.addParameters(binding, result);
            this.setDefaultValue(binding, result);
            this.addExceptions(binding, result);
            this.handleInterface(binding, result);
        }
        return result;
    }

    private void addAnnotationsAndModifiers(IMethodBinding binding, Method result) {
        result.getAnnotationsAndModifiers().addAll(this.toModifiersConverter.convert(binding.getModifiers()));
        try {
            IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
            int n = iAnnotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                result.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    private void addParameters(IMethodBinding binding, Method result) {
        if (binding.getDeclaredReceiverType() != null) {
            ReceiverParameter param = this.parametersFactory.createReceiverParameter();
            param.setTypeReference(this.toTypeReferencesConverter.convert(binding.getDeclaredReceiverType()).get(0));
            param.setName("");
            param.setThisReference(this.literalsFactory.createThis());
            result.getParameters().add((Object)param);
        }
        int index = 0;
        while (index < binding.getParameterTypes().length) {
            ITypeBinding typeBind = binding.getParameterTypes()[index];
            Object param = binding.isVarargs() && index == binding.getParameterTypes().length - 1 ? this.parametersFactory.createVariableLengthParameter() : this.parametersFactory.createOrdinaryParameter();
            param.setName("param" + index);
            param.setTypeReference(this.toTypeReferencesConverter.convert(typeBind).get(0));
            this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(typeBind, (ArrayTypeable)param);
            try {
                IAnnotationBinding[] binds;
                IAnnotationBinding[] iAnnotationBindingArray = binds = binding.getParameterAnnotations(index);
                int n = binds.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    param.getAnnotationsAndModifiers().add((Object)((AnnotationInstanceOrModifier)this.bindingToAnnotationInstanceConverter.convert(annotBind)));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            result.getParameters().add(param);
            ++index;
        }
    }

    private void addTypeParamters(IMethodBinding binding, Method result) {
        try {
            ITypeBinding[] iTypeBindingArray = binding.getTypeParameters();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeBind = iTypeBindingArray[n2];
                result.getTypeParameters().add((Object)this.bindingToTypeParameterConverter.convert(typeBind));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    private void setDefaultValue(IMethodBinding binding, Method result) {
        if (binding.getDefaultValue() != null) {
            ((InterfaceMethod)result).setDefaultValue(this.objectToAnnotationValueConverter.convert(binding.getDefaultValue()));
        }
    }

    private void handleInterface(IMethodBinding binding, Method result) {
        if (binding.getDeclaringClass().isInterface()) {
            boolean hasDefaultImpl = false;
            for (Modifier mod : result.getModifiers()) {
                if (!(mod instanceof Default)) continue;
                hasDefaultImpl = true;
                break;
            }
            if (!hasDefaultImpl) {
                result.setStatement((Statement)this.statementsFactory.createEmptyStatement());
            }
        }
    }

    private void addExceptions(IMethodBinding binding, Method result) {
        try {
            ITypeBinding[] iTypeBindingArray = binding.getExceptionTypes();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeBind = iTypeBindingArray[n2];
                result.getExceptions().add((Object)this.bindingToNamespaceClassifierReferenceConverter.convert(typeBind));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }
}

