/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modules.ExportsModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.ModulesFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToModuleConverter
implements Converter<IModuleBinding, Module> {
    private final ModulesFactory modulesFactory;
    private final ModifiersFactory modifiersFactory;
    private final UtilNamedElement utilNamedElement;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private JdtResolver jdtTResolverUtility;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;

    @Inject
    public BindingToModuleConverter(ModulesFactory modulesFactory, ModifiersFactory modifiersFactory, JdtResolver jdtTResolverUtility, UtilNamedElement utilNamedElement, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter) {
        this.modulesFactory = modulesFactory;
        this.modifiersFactory = modifiersFactory;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.utilNamedElement = utilNamedElement;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
    }

    @Override
    public Module convert(IModuleBinding binding) {
        Module result = this.jdtTResolverUtility.getModule(binding);
        if (result.eContents().isEmpty()) {
            this.addAnnotations(binding, result);
            if (binding.isOpen()) {
                result.setOpen(this.modifiersFactory.createOpen());
            }
            this.utilNamedElement.convertToNamespacesAndSet(binding.getName(), (NamespaceAwareElement)result);
            result.setName("");
            try {
                this.addTargets(binding, result);
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        return result;
    }

    private void addTargets(IModuleBinding binding, Module result) {
        IPackageBinding typeBind;
        ModuleReference ref;
        String modName;
        int n;
        int n2;
        String[] stringArray;
        String[] mods;
        ExportsModuleDirective dir;
        IPackageBinding packBind;
        IPackageBinding[] iPackageBindingArray = binding.getExportedPackages();
        int n3 = iPackageBindingArray.length;
        int n4 = 0;
        while (n4 < n3) {
            packBind = iPackageBindingArray[n4];
            dir = this.modulesFactory.createExportsModuleDirective();
            dir.setAccessablePackage(this.jdtTResolverUtility.getPackage(packBind));
            stringArray = mods = binding.getExportedTo(packBind);
            n2 = mods.length;
            n = 0;
            while (n < n2) {
                modName = stringArray[n];
                ref = this.modulesFactory.createModuleReference();
                ref.setTarget(this.jdtTResolverUtility.getModule(modName));
                dir.getModules().add((Object)ref);
                ++n;
            }
            result.getTarget().add((Object)dir);
            ++n4;
        }
        iPackageBindingArray = binding.getOpenedPackages();
        n3 = iPackageBindingArray.length;
        n4 = 0;
        while (n4 < n3) {
            packBind = iPackageBindingArray[n4];
            dir = this.modulesFactory.createOpensModuleDirective();
            dir.setAccessablePackage(this.jdtTResolverUtility.getPackage(packBind));
            stringArray = mods = binding.getOpenedTo(packBind);
            n2 = mods.length;
            n = 0;
            while (n < n2) {
                modName = stringArray[n];
                ref = this.modulesFactory.createModuleReference();
                ref.setTarget(this.jdtTResolverUtility.getModule(modName));
                dir.getModules().add((Object)ref);
                ++n;
            }
            result.getTarget().add((Object)dir);
            ++n4;
        }
        iPackageBindingArray = binding.getRequiredModules();
        n3 = iPackageBindingArray.length;
        n4 = 0;
        while (n4 < n3) {
            IPackageBinding modBind = iPackageBindingArray[n4];
            dir = this.modulesFactory.createRequiresModuleDirective();
            Module reqMod = this.jdtTResolverUtility.getModule((IModuleBinding)modBind);
            ModuleReference ref2 = this.modulesFactory.createModuleReference();
            ref2.setTarget(reqMod);
            dir.setRequiredModule(ref2);
            result.getTarget().add((Object)dir);
            ++n4;
        }
        iPackageBindingArray = binding.getUses();
        n3 = iPackageBindingArray.length;
        n4 = 0;
        while (n4 < n3) {
            typeBind = iPackageBindingArray[n4];
            dir = this.modulesFactory.createUsesModuleDirective();
            dir.setTypeReference(this.toTypeReferencesConverter.convert((ITypeBinding)typeBind).get(0));
            result.getTarget().add((Object)dir);
            ++n4;
        }
        iPackageBindingArray = binding.getServices();
        n3 = iPackageBindingArray.length;
        n4 = 0;
        while (n4 < n3) {
            typeBind = iPackageBindingArray[n4];
            dir = this.modulesFactory.createProvidesModuleDirective();
            dir.setTypeReference(this.toTypeReferencesConverter.convert((ITypeBinding)typeBind).get(0));
            ITypeBinding[] iTypeBindingArray = binding.getImplementations((ITypeBinding)typeBind);
            n = iTypeBindingArray.length;
            int n5 = 0;
            while (n5 < n) {
                ITypeBinding service = iTypeBindingArray[n5];
                dir.getServiceProviders().addAll((Collection)this.toTypeReferencesConverter.convert(service));
                ++n5;
            }
            result.getTarget().add((Object)dir);
            ++n4;
        }
    }

    private void addAnnotations(IModuleBinding binding, Module result) {
        try {
            IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
            int n = iAnnotationBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                result.getAnnotations().add((Object)this.bindingToAnnotationInstanceConverter.convert(annotBind));
                ++n2;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
    }

    @Inject
    public void setJdtTResolverUtility(JdtResolver jdtTResolverUtility) {
        this.jdtTResolverUtility = jdtTResolverUtility;
    }
}

