/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToNamespaceClassifierReferenceConverter
implements Converter<ITypeBinding, NamespaceClassifierReference> {
    private final TypesFactory typesFactory;
    private final JdtResolver jdtTResolverUtility;

    @Inject
    public BindingToNamespaceClassifierReferenceConverter(TypesFactory typesFactory, JdtResolver jdtTResolverUtility) {
        this.typesFactory = typesFactory;
        this.jdtTResolverUtility = jdtTResolverUtility;
    }

    @Override
    public NamespaceClassifierReference convert(ITypeBinding binding) {
        NamespaceClassifierReference ref = this.typesFactory.createNamespaceClassifierReference();
        if (binding.getPackage() != null) {
            Collections.addAll(ref.getNamespaces(), binding.getPackage().getNameComponents());
        }
        ClassifierReference classRef = this.typesFactory.createClassifierReference();
        classRef.setTarget(this.jdtTResolverUtility.getClassifier(binding));
        ref.getClassifierReferences().add((Object)classRef);
        return ref;
    }
}

