/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.containers.Package;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToPackageConverter
implements Converter<IPackageBinding, Package> {
    private final JdtResolver jdtTResolverUtility;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;

    @Inject
    public BindingToPackageConverter(JdtResolver jdtTResolverUtility, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
    }

    @Override
    public Package convert(IPackageBinding binding) {
        Package pack = this.jdtTResolverUtility.getPackage(binding);
        pack.setModule(this.jdtTResolverUtility.getModule(binding.getModule()));
        if (pack.getAnnotations().isEmpty()) {
            pack.getNamespaces().clear();
            Collections.addAll(pack.getNamespaces(), binding.getNameComponents());
            pack.setName("");
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    pack.getAnnotations().add((Object)this.bindingToAnnotationInstanceConverter.convert(annotBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        return pack;
    }
}

