/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class BindingToTypeParameterConverter
implements Converter<ITypeBinding, TypeParameter> {
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtTResolverUtility;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;

    @Inject
    public BindingToTypeParameterConverter(UtilNamedElement utilNamedElement, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, JdtResolver jdtTResolverUtility, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter) {
        this.utilNamedElement = utilNamedElement;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
    }

    @Override
    public TypeParameter convert(ITypeBinding binding) {
        TypeParameter result = this.jdtTResolverUtility.getTypeParameter(binding);
        if (result.eContainer() == null) {
            try {
                IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
                int n = iAnnotationBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding annotBind = iAnnotationBindingArray[n2];
                    result.getAnnotations().add((Object)this.bindingToAnnotationInstanceConverter.convert(annotBind));
                    ++n2;
                }
                iAnnotationBindingArray = binding.getTypeBounds();
                n = iAnnotationBindingArray.length;
                n2 = 0;
                while (n2 < n) {
                    IAnnotationBinding typeBind = iAnnotationBindingArray[n2];
                    result.getExtendTypes().addAll((Collection)this.toTypeReferencesConverter.convert((ITypeBinding)typeBind));
                    ++n2;
                }
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
            this.utilNamedElement.convertToNameAndSet(binding, (NamedElement)result);
        }
        return result;
    }
}

