/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializationValue;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializer;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ObjectToAnnotationValueConverter
implements Converter<Object, AnnotationValue> {
    private final ArraysFactory arraysFactory;
    private final ReferencesFactory referencesFactory;
    private final JdtResolver jdtTResolverUtility;
    private final Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter;
    private final Converter<ITypeBinding, Reference> bindingToInternalReferenceConverter;
    private final Converter<Object, PrimaryExpression> objectToPrimaryExpressionConverter;

    @Inject
    public ObjectToAnnotationValueConverter(ReferencesFactory referencesFactory, Converter<Object, PrimaryExpression> objectToPrimaryExpressionConverter, JdtResolver jdtTResolverUtility, Converter<ITypeBinding, Reference> bindingToInternalReferenceConverter, Converter<IAnnotationBinding, AnnotationInstance> bindingToAnnotationInstanceConverter, ArraysFactory arraysFactory) {
        this.arraysFactory = arraysFactory;
        this.referencesFactory = referencesFactory;
        this.jdtTResolverUtility = jdtTResolverUtility;
        this.bindingToAnnotationInstanceConverter = bindingToAnnotationInstanceConverter;
        this.bindingToInternalReferenceConverter = bindingToInternalReferenceConverter;
        this.objectToPrimaryExpressionConverter = objectToPrimaryExpressionConverter;
    }

    @Override
    public AnnotationValue convert(Object value) {
        if (value instanceof IVariableBinding var3_3) {
            Reference parentRef = this.bindingToInternalReferenceConverter.convert(varBind.getDeclaringClass());
            IdentifierReference varRef = this.referencesFactory.createIdentifierReference();
            varRef.setTarget((ReferenceableElement)this.jdtTResolverUtility.getEnumConstant((IVariableBinding)varBind));
            parentRef.setNext((Reference)varRef);
            result = this.getTopReference((Reference)varRef);
        } else if (value instanceof IAnnotationBinding) {
            result = (AnnotationValue)this.bindingToAnnotationInstanceConverter.convert((IAnnotationBinding)value);
        } else {
            if (value instanceof Object[] parentRef) {
                ArrayInitializer initializer = this.arraysFactory.createArrayInitializer();
                void var11_11 = values;
                int n = ((void)var11_11).length;
                int n2 = 0;
                while (n2 < n) {
                    void value2 = var11_11[n2];
                    initializer.getInitialValues().add((Object)((ArrayInitializationValue)this.convert((Object)value2)));
                    ++n2;
                }
                result = initializer;
            } else if (value instanceof ITypeBinding) {
                Reference parentRef = this.bindingToInternalReferenceConverter.convert((ITypeBinding)value);
                ReflectiveClassReference classRef = this.referencesFactory.createReflectiveClassReference();
                parentRef.setNext((Reference)classRef);
                result = this.getTopReference((Reference)classRef);
            } else {
                result = (AnnotationValue)this.objectToPrimaryExpressionConverter.convert(value);
            }
        }
        return result;
    }

    private Reference getTopReference(Reference ref) {
        Reference currentRef = ref;
        Reference parentRef = ref.getPrevious();
        while (parentRef != null) {
            currentRef = parentRef;
            parentRef = currentRef.getPrevious();
        }
        return currentRef;
    }
}

