/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.literals.BooleanLiteral;
import tools.mdsd.jamopp.model.java.literals.CharacterLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.NullLiteral;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;

public class ObjectToPrimaryExpressionConverter
implements Converter<Object, PrimaryExpression> {
    private final ReferencesFactory referencesFactory;
    private final LiteralsFactory literalsFactory;
    private final Map<Class<?>, Function<Object, PrimaryExpression>> mappings;

    @Inject
    public ObjectToPrimaryExpressionConverter(ReferencesFactory referencesFactory, LiteralsFactory literalsFactory) {
        this.referencesFactory = referencesFactory;
        this.literalsFactory = literalsFactory;
        this.mappings = new HashMap();
        this.mappings.put(String.class, this::handleString);
        this.mappings.put(Boolean.class, this::handleBoolean);
        this.mappings.put(Character.class, this::handleCharacter);
        this.mappings.put(Byte.class, this::handleByte);
        this.mappings.put(Short.class, this::handleShort);
        this.mappings.put(Integer.class, this::handleInteger);
        this.mappings.put(Long.class, this::handleLong);
        this.mappings.put(Float.class, this::handleFloat);
        this.mappings.put(Double.class, this::handleDouble);
    }

    @Override
    public PrimaryExpression convert(Object value) {
        NullLiteral result = null;
        for (Map.Entry<Class<?>, Function<Object, PrimaryExpression>> entry : this.mappings.entrySet()) {
            Class<?> key = entry.getKey();
            Function<Object, PrimaryExpression> val = entry.getValue();
            if (!key.isInstance(value)) continue;
            result = val.apply(value);
            break;
        }
        if (result == null) {
            result = this.literalsFactory.createNullLiteral();
        }
        return result;
    }

    private PrimaryExpression handleDouble(Object value) {
        DecimalDoubleLiteral literal = this.literalsFactory.createDecimalDoubleLiteral();
        literal.setDecimalValue(((Double)value).doubleValue());
        return literal;
    }

    private PrimaryExpression handleFloat(Object value) {
        DecimalFloatLiteral literal = this.literalsFactory.createDecimalFloatLiteral();
        literal.setDecimalValue(((Float)value).floatValue());
        return literal;
    }

    private PrimaryExpression handleLong(Object value) {
        DecimalLongLiteral literal = this.literalsFactory.createDecimalLongLiteral();
        literal.setDecimalValue(BigInteger.valueOf((Long)value));
        return literal;
    }

    private PrimaryExpression handleInteger(Object value) {
        DecimalIntegerLiteral literal = this.literalsFactory.createDecimalIntegerLiteral();
        literal.setDecimalValue(BigInteger.valueOf(((Integer)value).intValue()));
        return literal;
    }

    private PrimaryExpression handleShort(Object value) {
        DecimalIntegerLiteral literal = this.literalsFactory.createDecimalIntegerLiteral();
        literal.setDecimalValue(BigInteger.valueOf(((Short)value).shortValue()));
        return literal;
    }

    private PrimaryExpression handleByte(Object value) {
        DecimalIntegerLiteral literal = this.literalsFactory.createDecimalIntegerLiteral();
        literal.setDecimalValue(BigInteger.valueOf(((Byte)value).byteValue()));
        return literal;
    }

    private PrimaryExpression handleCharacter(Object value) {
        CharacterLiteral literal = this.literalsFactory.createCharacterLiteral();
        literal.setValue("\\u" + Integer.toHexString(((Character)value).charValue()));
        return literal;
    }

    private PrimaryExpression handleBoolean(Object value) {
        BooleanLiteral literal = this.literalsFactory.createBooleanLiteral();
        literal.setValue(((Boolean)value).booleanValue());
        return literal;
    }

    private PrimaryExpression handleString(Object value) {
        StringReference ref = this.referencesFactory.createStringReference();
        ref.setValue((String)value);
        return ref;
    }
}

