/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToSwitchCasesAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class SwitchToSwitchConverter
implements Converter<SwitchStatement, Switch> {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final ToSwitchCasesAndSetConverter toSwitchCasesAndSetConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;

    @Inject
    public SwitchToSwitchConverter(ToSwitchCasesAndSetConverter toSwitchCasesAndSetConverter, StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toSwitchCasesAndSetConverter = toSwitchCasesAndSetConverter;
    }

    @Override
    public Switch convert(SwitchStatement switchSt) {
        Switch result = this.statementsFactory.createSwitch();
        result.setVariable(this.expressionConverterUtility.convert(switchSt.getExpression()));
        this.toSwitchCasesAndSetConverter.convert(result, switchSt.statements());
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)switchSt);
        return result;
    }
}

