/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.AdditiveExpression;
import tools.mdsd.jamopp.model.java.expressions.AdditiveExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.operators.AdditiveOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToAdditiveExpressionConverter
implements Converter<InfixExpression, AdditiveExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<InfixExpression.Operator, AdditiveOperator> toAdditiveOperatorConverter;

    @Inject
    public ToAdditiveExpressionConverter(Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, Converter<InfixExpression.Operator, AdditiveOperator> toAdditiveOperatorConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.expressionsFactory = expressionsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.toAdditiveOperatorConverter = toAdditiveOperatorConverter;
    }

    @Override
    public AdditiveExpression convert(InfixExpression expr) {
        AdditiveExpression result = this.expressionsFactory.createAdditiveExpression();
        this.mergeAdditiveExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getLeftOperand()));
        result.getAdditiveOperators().add((Object)this.toAdditiveOperatorConverter.convert(expr.getOperator()));
        this.mergeAdditiveExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getRightOperand()));
        expr.extendedOperands().forEach(obj -> {
            result.getAdditiveOperators().add((Object)this.toAdditiveOperatorConverter.convert(expr.getOperator()));
            this.mergeAdditiveExpressionAndExpression(result, this.toExpressionConverter.convert((Expression)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private void mergeAdditiveExpressionAndExpression(AdditiveExpression addExpr, tools.mdsd.jamopp.model.java.expressions.Expression potChild) {
        if (potChild instanceof AdditiveExpressionChild) {
            addExpr.getChildren().add((Object)((AdditiveExpressionChild)potChild));
        } else {
            AdditiveExpression expr = (AdditiveExpression)potChild;
            addExpr.getChildren().addAll((Collection)expr.getChildren());
            addExpr.getAdditiveOperators().addAll((Collection)expr.getAdditiveOperators());
        }
    }
}

