/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameter;
import tools.mdsd.jamopp.model.java.annotations.AnnotationParameterList;
import tools.mdsd.jamopp.model.java.annotations.AnnotationsFactory;
import tools.mdsd.jamopp.model.java.annotations.SingleAnnotationParameter;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

@Singleton
public class ToAnnotationInstanceConverter
implements Converter<org.eclipse.jdt.core.dom.Annotation, AnnotationInstance> {
    private final AnnotationsFactory annotationsFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final Provider<UtilTypeInstructionSeparation> typeInstructionSeparationUtility;

    @Inject
    public ToAnnotationInstanceConverter(UtilNamedElement utilNamedElement, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, AnnotationsFactory annotationsFactory, Provider<UtilTypeInstructionSeparation> typeInstructionSeparationUtility) {
        this.annotationsFactory = annotationsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilNamedElement = utilNamedElement;
        this.typeInstructionSeparationUtility = typeInstructionSeparationUtility;
    }

    @Override
    public AnnotationInstance convert(org.eclipse.jdt.core.dom.Annotation annot) {
        AnnotationInstance result = this.annotationsFactory.createAnnotationInstance();
        this.utilNamedElement.addNameToNameSpace(annot.getTypeName(), (NamespaceAwareElement)result);
        IAnnotationBinding binding = annot.resolveAnnotationBinding();
        Annotation proxyClass = binding == null ? this.jdtResolverUtility.getAnnotation(annot.getTypeName().getFullyQualifiedName()) : this.jdtResolverUtility.getAnnotation(binding.getAnnotationType());
        result.setAnnotation((Classifier)proxyClass);
        if (annot.isSingleMemberAnnotation()) {
            this.handleSingleMemberAnnotation(annot, result);
        } else if (annot.isNormalAnnotation()) {
            this.handleNormalAnnotation(annot, result, proxyClass);
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)annot);
        return result;
    }

    private void handleNormalAnnotation(org.eclipse.jdt.core.dom.Annotation annot, AnnotationInstance result, Annotation proxyClass) {
        AnnotationParameterList param = this.annotationsFactory.createAnnotationParameterList();
        result.setParameter((AnnotationParameter)param);
        NormalAnnotation normalAnnot = (NormalAnnotation)annot;
        normalAnnot.values().forEach(obj -> {
            InterfaceMethod methodProxy;
            MemberValuePair memVal = (MemberValuePair)obj;
            AnnotationAttributeSetting attrSet = this.annotationsFactory.createAnnotationAttributeSetting();
            if (memVal.resolveMemberValuePairBinding() != null) {
                methodProxy = this.jdtResolverUtility.getInterfaceMethod(memVal.resolveMemberValuePairBinding().getMethodBinding());
            } else {
                methodProxy = this.jdtResolverUtility.getInterfaceMethod(memVal.getName().getIdentifier());
                if (!proxyClass.getMembers().contains((Object)methodProxy)) {
                    proxyClass.getMembers().add((Object)methodProxy);
                }
            }
            this.utilNamedElement.setNameOfElement((Name)memVal.getName(), (NamedElement)methodProxy);
            attrSet.setAttribute(methodProxy);
            ((UtilTypeInstructionSeparation)this.typeInstructionSeparationUtility.get()).addAnnotationAttributeSetting(memVal.getValue(), attrSet);
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)attrSet, (ASTNode)memVal);
            param.getSettings().add((Object)attrSet);
        });
    }

    private void handleSingleMemberAnnotation(org.eclipse.jdt.core.dom.Annotation annot, AnnotationInstance result) {
        SingleAnnotationParameter param = this.annotationsFactory.createSingleAnnotationParameter();
        result.setParameter((AnnotationParameter)param);
        SingleMemberAnnotation singleAnnot = (SingleMemberAnnotation)annot;
        ((UtilTypeInstructionSeparation)this.typeInstructionSeparationUtility.get()).addSingleAnnotationParameter(singleAnnot.getValue(), param);
    }
}

