/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToAnonymousClassConverter
implements Converter<AnonymousClassDeclaration, AnonymousClass> {
    private final JdtResolver utilJDTResolver;
    private final UtilLayout utilLayout;
    private final Converter<BodyDeclaration, Member> toClassMemberConverter;

    @Inject
    public ToAnonymousClassConverter(UtilLayout utilLayout, JdtResolver utilJDTResolver, @Named(value="ToClassMemberConverter") Converter<BodyDeclaration, Member> toClassMemberConverter) {
        this.utilJDTResolver = utilJDTResolver;
        this.utilLayout = utilLayout;
        this.toClassMemberConverter = toClassMemberConverter;
    }

    @Override
    public AnonymousClass convert(AnonymousClassDeclaration anon) {
        ITypeBinding binding = anon.resolveBinding();
        AnonymousClass result = binding != null ? this.utilJDTResolver.getAnonymousClass(binding) : this.utilJDTResolver.getAnonymousClass(String.valueOf(anon.hashCode()));
        anon.bodyDeclarations().forEach(obj -> {
            boolean bl = result.getMembers().add((Object)this.toClassMemberConverter.convert((BodyDeclaration)obj));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)anon);
        return result;
    }
}

