/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayInitializationValue;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToArrayInitialisierConverter
implements Converter<ArrayInitializer, tools.mdsd.jamopp.model.java.arrays.ArrayInitializer> {
    private final ArraysFactory arraysFactory;
    private final UtilLayout utilLayout;
    private final Provider<Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression>> utilExpressionConverter;
    private final Provider<Converter<Annotation, AnnotationInstance>> toAnnotationInstanceConverter;

    @Inject
    public ToArrayInitialisierConverter(UtilLayout utilLayout, ArraysFactory arraysFactory, Provider<Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression>> utilExpressionConverter, Provider<Converter<Annotation, AnnotationInstance>> toAnnotationInstanceConverter) {
        this.arraysFactory = arraysFactory;
        this.utilLayout = utilLayout;
        this.utilExpressionConverter = utilExpressionConverter;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.arrays.ArrayInitializer convert(ArrayInitializer arr) {
        tools.mdsd.jamopp.model.java.arrays.ArrayInitializer result = this.arraysFactory.createArrayInitializer();
        arr.expressions().forEach(obj -> {
            Expression expr = (Expression)obj;
            Object value = expr instanceof ArrayInitializer ? this.convert((ArrayInitializer)expr) : (expr instanceof Annotation ? (ArrayInitializationValue)((Converter)this.toAnnotationInstanceConverter.get()).convert((Annotation)expr) : (ArrayInitializationValue)((Converter)this.utilExpressionConverter.get()).convert(expr));
            result.getInitialValues().add(value);
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }
}

