/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jdt.core.dom.Assignment;
import tools.mdsd.jamopp.model.java.operators.AssignmentOperator;
import tools.mdsd.jamopp.model.java.operators.OperatorsFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;

public class ToAssignmentConverter
implements Converter<Assignment.Operator, AssignmentOperator> {
    private final OperatorsFactory operatorsFactory;
    private final Map<Assignment.Operator, Supplier<AssignmentOperator>> mapping;

    @Inject
    public ToAssignmentConverter(OperatorsFactory operatorsFactory) {
        this.operatorsFactory = operatorsFactory;
        this.mapping = new HashMap<Assignment.Operator, Supplier<AssignmentOperator>>();
        this.mapping.put(Assignment.Operator.ASSIGN, () -> operatorsFactory.createAssignment());
        this.mapping.put(Assignment.Operator.BIT_AND_ASSIGN, () -> operatorsFactory.createAssignmentAnd());
        this.mapping.put(Assignment.Operator.BIT_OR_ASSIGN, () -> operatorsFactory.createAssignmentOr());
        this.mapping.put(Assignment.Operator.BIT_XOR_ASSIGN, () -> operatorsFactory.createAssignmentExclusiveOr());
        this.mapping.put(Assignment.Operator.DIVIDE_ASSIGN, () -> operatorsFactory.createAssignmentDivision());
        this.mapping.put(Assignment.Operator.LEFT_SHIFT_ASSIGN, () -> operatorsFactory.createAssignmentLeftShift());
        this.mapping.put(Assignment.Operator.MINUS_ASSIGN, () -> operatorsFactory.createAssignmentMinus());
        this.mapping.put(Assignment.Operator.PLUS_ASSIGN, () -> operatorsFactory.createAssignmentPlus());
        this.mapping.put(Assignment.Operator.REMAINDER_ASSIGN, () -> operatorsFactory.createAssignmentModulo());
        this.mapping.put(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, () -> operatorsFactory.createAssignmentRightShift());
        this.mapping.put(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, () -> operatorsFactory.createAssignmentUnsignedRightShift());
    }

    @Override
    public AssignmentOperator convert(Assignment.Operator operator) {
        return this.mapping.getOrDefault(operator, () -> this.operatorsFactory.createAssignmentMultiplication()).get();
    }
}

