/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.statements.CatchBlock;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToCatchblockConverter
implements Converter<CatchClause, CatchBlock> {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> annotationInstanceConverter;
    private final Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter;

    @Inject
    public ToCatchblockConverter(UtilNamedElement utilNamedElement, Converter<Type, TypeReference> toTypeReferenceConverter, StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, Converter<IExtendedModifier, AnnotationInstanceOrModifier> annotationInstanceConverter, Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilNamedElement = utilNamedElement;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.annotationInstanceConverter = annotationInstanceConverter;
        this.blockToBlockConverter = blockToBlockConverter;
    }

    @Override
    public CatchBlock convert(CatchClause block) {
        CatchBlock result = this.statementsFactory.createCatchBlock();
        SingleVariableDeclaration decl = block.getException();
        IVariableBinding binding = decl.resolveBinding();
        CatchParameter param = binding == null ? this.jdtResolverUtility.getCatchParameter(String.valueOf(decl.getName().getIdentifier()) + "-" + block.hashCode()) : this.jdtResolverUtility.getCatchParameter(binding);
        decl.modifiers().forEach(obj -> {
            boolean bl = param.getAnnotationsAndModifiers().add((Object)this.annotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        if (decl.getType().isUnionType()) {
            UnionType unionType = (UnionType)decl.getType();
            param.setTypeReference(this.toTypeReferenceConverter.convert((Type)unionType.types().get(0)));
            int index = 1;
            while (index < unionType.types().size()) {
                param.getTypeReferences().add((Object)this.toTypeReferenceConverter.convert((Type)unionType.types().get(index)));
                ++index;
            }
        } else {
            param.setTypeReference(this.toTypeReferenceConverter.convert(decl.getType()));
        }
        this.utilNamedElement.setNameOfElement((Name)decl.getName(), (NamedElement)param);
        result.setParameter((OrdinaryParameter)param);
        result.setBlock(this.blockToBlockConverter.convert(block.getBody()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)block);
        return result;
    }
}

