/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;

@Singleton
public class ToClassMemberConverter
implements Converter<BodyDeclaration, Member> {
    private final Provider<Converter<AbstractTypeDeclaration, ConcreteClassifier>> toConcreteClassifierConverter;
    private final Converter<Initializer, Block> toBlockConverter;
    private final Converter<FieldDeclaration, Field> toFieldConverter;
    private final Converter<MethodDeclaration, Member> toClassMethodOrConstructorConverter;
    private final Converter<AnnotationTypeMemberDeclaration, InterfaceMethod> toInterfaceMethodConverter;

    @Inject
    public ToClassMemberConverter(Converter<Initializer, Block> toBlockConverter, @Named(value="ToClassMethodOrConstructorConverter") Converter<MethodDeclaration, Member> toClassMethodOrConstructorConverter, Converter<AnnotationTypeMemberDeclaration, InterfaceMethod> toInterfaceMethodConverter, Converter<FieldDeclaration, Field> toFieldConverter, Provider<Converter<AbstractTypeDeclaration, ConcreteClassifier>> toConcreteClassifierConverter) {
        this.toConcreteClassifierConverter = toConcreteClassifierConverter;
        this.toBlockConverter = toBlockConverter;
        this.toFieldConverter = toFieldConverter;
        this.toClassMethodOrConstructorConverter = toClassMethodOrConstructorConverter;
        this.toInterfaceMethodConverter = toInterfaceMethodConverter;
    }

    @Override
    public Member convert(BodyDeclaration body) {
        Member result = null;
        if (body instanceof AbstractTypeDeclaration) {
            result = (Member)((Converter)this.toConcreteClassifierConverter.get()).convert((AbstractTypeDeclaration)body);
        } else if (body.getNodeType() == 28) {
            result = (Member)this.toBlockConverter.convert((Initializer)body);
        } else if (body.getNodeType() == 23) {
            result = (Member)this.toFieldConverter.convert((FieldDeclaration)body);
        } else if (body.getNodeType() == 31) {
            result = this.toClassMethodOrConstructorConverter.convert((MethodDeclaration)body);
        } else if (body.getNodeType() == 82) {
            result = (Member)this.toInterfaceMethodConverter.convert((AnnotationTypeMemberDeclaration)body);
        }
        return result;
    }
}

