/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToClassMethodOrConstructorConverter
implements Converter<MethodDeclaration, Member> {
    private final StatementsFactory statementsFactory;
    private final JdtResolver jdtResolverUtility;
    private final UtilTypeInstructionSeparation utilTypeInstructionSeparation;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final UtilNamedElement utilNamedElement;
    private final Converter<MethodDeclaration, ReceiverParameter> toReceiverParameterConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<org.eclipse.jdt.core.dom.TypeParameter, TypeParameter> toTypeParameterConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<SingleVariableDeclaration, Parameter> toParameterConverter;
    private final Converter<TypeReference, NamespaceClassifierReference> inNamespaceClassifierReferenceWrapper;

    @Inject
    public ToClassMethodOrConstructorConverter(UtilTypeInstructionSeparation utilTypeInstructionSeparation, UtilNamedElement utilNamedElement, UtilLayout utilLayout, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<org.eclipse.jdt.core.dom.TypeParameter, TypeParameter> toTypeParameterConverter, Converter<MethodDeclaration, ReceiverParameter> toReceiverParameterConverter, Converter<SingleVariableDeclaration, Parameter> toParameterConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, JdtResolver jdtResolverUtility, Converter<TypeReference, NamespaceClassifierReference> inNamespaceClassifierReferenceWrapper, StatementsFactory statementsFactory, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.statementsFactory = statementsFactory;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilNamedElement = utilNamedElement;
        this.toReceiverParameterConverter = toReceiverParameterConverter;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toTypeParameterConverter = toTypeParameterConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toParameterConverter = toParameterConverter;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.inNamespaceClassifierReferenceWrapper = inNamespaceClassifierReferenceWrapper;
        this.utilTypeInstructionSeparation = utilTypeInstructionSeparation;
        this.utilLayout = utilLayout;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public Member convert(MethodDeclaration methodDecl) {
        Member result = methodDecl.isConstructor() ? this.handleConstructor(methodDecl) : this.handleClassMethod(methodDecl);
        return result;
    }

    private Member handleClassMethod(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        ClassMethod result = binding != null ? this.jdtResolverUtility.getClassMethod(binding) : this.jdtResolverUtility.getClassMethod(methodDecl.getName().getIdentifier());
        methodDecl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        methodDecl.typeParameters().forEach(obj -> {
            boolean bl = result.getTypeParameters().add((Object)this.toTypeParameterConverter.convert((org.eclipse.jdt.core.dom.TypeParameter)obj));
        });
        result.setTypeReference(this.toTypeReferenceConverter.convert(methodDecl.getReturnType2()));
        this.utilToArrayDimensionsAndSetConverter.convert(methodDecl.getReturnType2(), (ArrayTypeable)result);
        methodDecl.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)result));
        this.utilNamedElement.setNameOfElement((Name)methodDecl.getName(), (NamedElement)result);
        if (methodDecl.getReceiverType() != null) {
            result.getParameters().add((Object)((Parameter)this.toReceiverParameterConverter.convert(methodDecl)));
        }
        methodDecl.parameters().forEach(obj -> {
            boolean bl = result.getParameters().add((Object)this.toParameterConverter.convert((SingleVariableDeclaration)obj));
        });
        methodDecl.thrownExceptionTypes().forEach(obj -> {
            boolean bl = result.getExceptions().add((Object)this.inNamespaceClassifierReferenceWrapper.convert(this.toTypeReferenceConverter.convert((Type)obj)));
        });
        if (methodDecl.getBody() != null) {
            this.utilTypeInstructionSeparation.addMethod(methodDecl.getBody(), (Method)result);
        } else {
            result.setStatement((Statement)this.statementsFactory.createEmptyStatement());
        }
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)methodDecl);
        return result;
    }

    private Member handleConstructor(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        Constructor result = binding == null ? this.jdtResolverUtility.getConstructor(methodDecl.getName().getIdentifier()) : this.jdtResolverUtility.getConstructor(binding);
        methodDecl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        methodDecl.typeParameters().forEach(obj -> {
            boolean bl = result.getTypeParameters().add((Object)this.toTypeParameterConverter.convert((org.eclipse.jdt.core.dom.TypeParameter)obj));
        });
        this.utilNamedElement.setNameOfElement((Name)methodDecl.getName(), (NamedElement)result);
        if (methodDecl.getReceiverType() != null) {
            result.getParameters().add((Object)((Parameter)this.toReceiverParameterConverter.convert(methodDecl)));
        }
        methodDecl.parameters().forEach(obj -> {
            boolean bl = result.getParameters().add((Object)this.toParameterConverter.convert((SingleVariableDeclaration)obj));
        });
        methodDecl.thrownExceptionTypes().forEach(obj -> {
            boolean bl = result.getExceptions().add((Object)this.inNamespaceClassifierReferenceWrapper.convert(this.toTypeReferenceConverter.convert((Type)obj)));
        });
        this.utilTypeInstructionSeparation.addConstructor(methodDecl.getBody(), result);
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)methodDecl);
        return result;
    }
}

