/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToClassOrInterfaceConverter
implements Converter<TypeDeclaration, ConcreteClassifier> {
    private final JdtResolver iUtilJdtResolver;
    private final Converter<BodyDeclaration, Member> toClassMemberConverter;
    private final Converter<BodyDeclaration, Member> toInterfaceMemberConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<org.eclipse.jdt.core.dom.TypeParameter, TypeParameter> toTypeParameterConverter;

    @Inject
    public ToClassOrInterfaceConverter(JdtResolver iUtilJdtResolver, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<org.eclipse.jdt.core.dom.TypeParameter, TypeParameter> toTypeParameterConverter, @Named(value="ToInterfaceMemberConverter") Converter<BodyDeclaration, Member> toInterfaceMemberConverter, @Named(value="ToClassMemberConverter") Converter<BodyDeclaration, Member> toClassMemberConverter) {
        this.toTypeParameterConverter = toTypeParameterConverter;
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.toClassMemberConverter = toClassMemberConverter;
        this.toInterfaceMemberConverter = toInterfaceMemberConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
    }

    @Override
    public ConcreteClassifier convert(TypeDeclaration typeDecl) {
        Interface result;
        if (typeDecl.isInterface()) {
            Interface interfaceObj = this.iUtilJdtResolver.getInterface(typeDecl.resolveBinding());
            typeDecl.typeParameters().forEach(obj -> {
                boolean bl = interfaceObj.getTypeParameters().add((Object)this.toTypeParameterConverter.convert((org.eclipse.jdt.core.dom.TypeParameter)obj));
            });
            typeDecl.superInterfaceTypes().forEach(obj -> {
                boolean bl = interfaceObj.getExtends().add((Object)this.toTypeReferenceConverter.convert((Type)obj));
            });
            typeDecl.bodyDeclarations().forEach(obj -> {
                boolean bl = interfaceObj.getMembers().add((Object)this.toInterfaceMemberConverter.convert((BodyDeclaration)obj));
            });
            result = interfaceObj;
        } else {
            Class classObj = this.iUtilJdtResolver.getClass(typeDecl.resolveBinding());
            typeDecl.typeParameters().forEach(obj -> {
                boolean bl = classObj.getTypeParameters().add((Object)this.toTypeParameterConverter.convert((org.eclipse.jdt.core.dom.TypeParameter)obj));
            });
            if (typeDecl.getSuperclassType() != null) {
                classObj.setExtends(this.toTypeReferenceConverter.convert(typeDecl.getSuperclassType()));
            }
            typeDecl.superInterfaceTypes().forEach(obj -> {
                boolean bl = classObj.getImplements().add((Object)this.toTypeReferenceConverter.convert((Type)obj));
            });
            typeDecl.bodyDeclarations().forEach(obj -> {
                boolean bl = classObj.getMembers().add((Object)this.toClassMemberConverter.convert((BodyDeclaration)obj));
            });
            result = classObj;
        }
        return result;
    }
}

