/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;

public class ToClassifierOrNamespaceClassifierReferenceConverter
implements Converter<Name, TypeReference> {
    private final TypesFactory typesFactory;
    private final UtilNamedElement utilNamedElement;
    private final Converter<SimpleName, ClassifierReference> toClassifierReferenceConverter;

    @Inject
    public ToClassifierOrNamespaceClassifierReferenceConverter(UtilNamedElement utilNamedElement, Converter<SimpleName, ClassifierReference> toClassifierReferenceConverter, TypesFactory typesFactory) {
        this.typesFactory = typesFactory;
        this.utilNamedElement = utilNamedElement;
        this.toClassifierReferenceConverter = toClassifierReferenceConverter;
    }

    @Override
    public TypeReference convert(Name name) {
        TypeReference result;
        if (name.isSimpleName()) {
            result = (TypeReference)this.toClassifierReferenceConverter.convert((SimpleName)name);
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            NamespaceClassifierReference ref = this.typesFactory.createNamespaceClassifierReference();
            if (name.resolveBinding() == null) {
                this.handleResolveBindingsNull(qualifiedName, ref);
            } else {
                this.handleResolveBindingsNotNull(qualifiedName, ref);
            }
            result = ref;
        }
        return result;
    }

    private void handleResolveBindingsNotNull(QualifiedName qualifiedName, NamespaceClassifierReference ref) {
        Optional<Object> qualifier = Optional.of(qualifiedName.getQualifier());
        Optional<Object> simpleName = Optional.of(qualifiedName.getName());
        while (simpleName.isPresent() && simpleName.get().resolveBinding() instanceof ITypeBinding) {
            ref.getClassifierReferences().add(0, (Object)this.toClassifierReferenceConverter.convert(simpleName.get()));
            if (qualifier.isEmpty()) {
                simpleName = Optional.empty();
                continue;
            }
            if (qualifier.get().isSimpleName()) {
                simpleName = Optional.of((SimpleName)qualifier.get());
                qualifier = Optional.empty();
                continue;
            }
            simpleName = Optional.of(((QualifiedName)qualifier.get()).getName());
            qualifier = Optional.of(((QualifiedName)qualifier.get()).getQualifier());
        }
        if (simpleName.isPresent() && !(simpleName.get().resolveBinding() instanceof ITypeBinding)) {
            this.utilNamedElement.addNameToNameSpace((Name)simpleName.get(), (NamespaceAwareElement)ref);
        }
        if (qualifier.isPresent()) {
            this.utilNamedElement.addNameToNameSpace(qualifier.get(), (NamespaceAwareElement)ref);
        }
    }

    private void handleResolveBindingsNull(QualifiedName qualifiedName, NamespaceClassifierReference ref) {
        ref.getClassifierReferences().add((Object)this.toClassifierReferenceConverter.convert(qualifiedName.getName()));
        this.utilNamedElement.addNameToNameSpace(qualifiedName.getQualifier(), (NamespaceAwareElement)ref);
    }
}

