/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToClassifierReferenceConverter
implements Converter<SimpleName, ClassifierReference> {
    private final TypesFactory typesFactory;
    private final JdtResolver jdtResolverUtility;

    @Inject
    public ToClassifierReferenceConverter(JdtResolver jdtResolverUtility, TypesFactory typesFactory) {
        this.typesFactory = typesFactory;
        this.jdtResolverUtility = jdtResolverUtility;
    }

    @Override
    public ClassifierReference convert(SimpleName simpleName) {
        ClassifierReference ref = this.typesFactory.createClassifierReference();
        ITypeBinding binding = (ITypeBinding)simpleName.resolveBinding();
        Object proxy = binding == null || binding.isRecovered() ? this.jdtResolverUtility.getClass(simpleName.getIdentifier()) : this.jdtResolverUtility.getClassifier(binding);
        proxy.setName(simpleName.getIdentifier());
        ref.setTarget((Classifier)proxy);
        return ref;
    }
}

