/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToConcreteClassifierConverterImpl
implements Converter<AbstractTypeDeclaration, ConcreteClassifier> {
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<BodyDeclaration, Member> toInterfaceMember;
    private final Converter<TypeDeclaration, ConcreteClassifier> toClassOrInterface;
    private final Converter<EnumDeclaration, Enumeration> toEnumConverter;

    @Inject
    public ToConcreteClassifierConverterImpl(Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, UtilNamedElement utilNamedElement, @Named(value="ToInterfaceMemberConverter") Converter<BodyDeclaration, Member> toInterfaceMember, Converter<EnumDeclaration, Enumeration> toEnumConverter, Converter<TypeDeclaration, ConcreteClassifier> toClassOrInterface) {
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toInterfaceMember = toInterfaceMember;
        this.toClassOrInterface = toClassOrInterface;
        this.toEnumConverter = toEnumConverter;
        this.utilNamedElement = utilNamedElement;
    }

    @Override
    public ConcreteClassifier convert(AbstractTypeDeclaration typeDecl) {
        ConcreteClassifier result;
        if (typeDecl.getNodeType() == 55) {
            result = this.toClassOrInterface.convert((TypeDeclaration)typeDecl);
        } else if (typeDecl.getNodeType() == 81) {
            ConcreteClassifier concreteClassifier = result = this.jdtResolverUtility.getAnnotation(typeDecl.resolveBinding());
            typeDecl.bodyDeclarations().forEach(obj -> {
                boolean bl = concreteClassifier.getMembers().add((Object)this.toInterfaceMember.convert((BodyDeclaration)obj));
            });
        } else {
            result = (ConcreteClassifier)this.toEnumConverter.convert((EnumDeclaration)typeDecl);
        }
        ConcreteClassifier finalResult = result;
        typeDecl.modifiers().forEach(obj -> {
            boolean bl = finalResult.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        this.utilNamedElement.setNameOfElement((Name)typeDecl.getName(), (NamedElement)result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)typeDecl);
        return result;
    }
}

