/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.UsesDirective;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.ModuleRequiresModifier;
import tools.mdsd.jamopp.model.java.modules.AccessProvidingModuleDirective;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.ModulesFactory;
import tools.mdsd.jamopp.model.java.modules.ProvidesModuleDirective;
import tools.mdsd.jamopp.model.java.modules.RequiresModuleDirective;
import tools.mdsd.jamopp.model.java.modules.UsesModuleDirective;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToDirectiveConverter
implements Converter<ModuleDirective, tools.mdsd.jamopp.model.java.modules.ModuleDirective> {
    private final ModulesFactory modulesFactory;
    private final ModifiersFactory modifiersFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final Converter<Name, TypeReference> utilBaseConverter;
    private final Converter<Name, ModuleReference> toModuleReferenceConverter;

    @Inject
    public ToDirectiveConverter(Converter<Name, TypeReference> utilBaseConverter, Converter<Name, ModuleReference> toModuleReferenceConverter, ModulesFactory modulesFactory, ModifiersFactory modifiersFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility) {
        this.modulesFactory = modulesFactory;
        this.modifiersFactory = modifiersFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilBaseConverter = utilBaseConverter;
        this.toModuleReferenceConverter = toModuleReferenceConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.modules.ModuleDirective convert(ModuleDirective directive) {
        tools.mdsd.jamopp.model.java.modules.ModuleDirective result = directive.getNodeType() == 94 ? this.handleRequiresDirective(directive) : (directive.getNodeType() == 95 || directive.getNodeType() == 96 ? this.handlesExportsAndOpensDirective(directive) : (directive.getNodeType() == 98 ? this.handleProvidesDirective(directive) : this.handleUsesDirective(directive)));
        return result;
    }

    private tools.mdsd.jamopp.model.java.modules.ModuleDirective handlesExportsAndOpensDirective(ModuleDirective directive) {
        ModulePackageAccess accessDir = (ModulePackageAccess)directive;
        Object convertedDir = directive.getNodeType() == 96 ? this.modulesFactory.createOpensModuleDirective() : this.modulesFactory.createExportsModuleDirective();
        IPackageBinding binding = (IPackageBinding)accessDir.getName().resolveBinding();
        convertedDir.setAccessablePackage(this.jdtResolverUtility.getPackage(binding));
        accessDir.modules().forEach(arg_0 -> this.lambda$0((AccessProvidingModuleDirective)convertedDir, arg_0));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedDir, (ASTNode)directive);
        return convertedDir;
    }

    private tools.mdsd.jamopp.model.java.modules.ModuleDirective handleUsesDirective(ModuleDirective directive) {
        UsesDirective usDir = (UsesDirective)directive;
        UsesModuleDirective result = this.modulesFactory.createUsesModuleDirective();
        result.setTypeReference(this.utilBaseConverter.convert(usDir.getName()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
        return result;
    }

    private tools.mdsd.jamopp.model.java.modules.ModuleDirective handleRequiresDirective(ModuleDirective directive) {
        RequiresDirective reqDir = (RequiresDirective)directive;
        RequiresModuleDirective result = this.modulesFactory.createRequiresModuleDirective();
        reqDir.modifiers().forEach(obj -> {
            ModuleModifier modifier = (ModuleModifier)obj;
            if (modifier.isStatic()) {
                result.setModifier((ModuleRequiresModifier)this.modifiersFactory.createStatic());
            } else if (modifier.isTransitive()) {
                result.setModifier((ModuleRequiresModifier)this.modifiersFactory.createTransitive());
            }
        });
        result.setRequiredModule(this.toModuleReferenceConverter.convert(reqDir.getName()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
        return result;
    }

    private tools.mdsd.jamopp.model.java.modules.ModuleDirective handleProvidesDirective(ModuleDirective directive) {
        ProvidesDirective provDir = (ProvidesDirective)directive;
        ProvidesModuleDirective result = this.modulesFactory.createProvidesModuleDirective();
        result.setTypeReference(this.utilBaseConverter.convert(provDir.getName()));
        provDir.implementations().forEach(obj -> {
            boolean bl = result.getServiceProviders().add((Object)this.utilBaseConverter.convert((Name)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)directive);
        return result;
    }

    private /* synthetic */ void lambda$0(AccessProvidingModuleDirective accessProvidingModuleDirective, Object obj) {
        boolean bl = accessProvidingModuleDirective.getModules().add((Object)this.toModuleReferenceConverter.convert((Name)obj));
    }
}

