/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToEnumConstantConverter
implements Converter<EnumConstantDeclaration, EnumConstant> {
    private final JdtResolver iUtilJdtResolver;
    private final UtilLayout utilLayout;
    private final UtilNamedElement utilNamedElement;
    private final Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> utilExpressionConverter;
    private final Converter<AnonymousClassDeclaration, AnonymousClass> toAnonymousClassConverter;

    @Inject
    public ToEnumConstantConverter(UtilNamedElement utilNamedElement, UtilLayout utilLayout, JdtResolver iUtilJdtResolver, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> utilExpressionConverter, Converter<AnonymousClassDeclaration, AnonymousClass> toAnonymousClassConverter, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter) {
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.utilNamedElement = utilNamedElement;
        this.utilExpressionConverter = utilExpressionConverter;
        this.toAnonymousClassConverter = toAnonymousClassConverter;
        this.utilLayout = utilLayout;
    }

    @Override
    public EnumConstant convert(EnumConstantDeclaration enDecl) {
        IVariableBinding binding = enDecl.resolveVariable();
        EnumConstant result = binding == null ? this.iUtilJdtResolver.getEnumConstant(enDecl.getName().getIdentifier()) : this.iUtilJdtResolver.getEnumConstant(binding);
        enDecl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        this.utilNamedElement.setNameOfElement((Name)enDecl.getName(), (NamedElement)result);
        enDecl.arguments().forEach(obj -> {
            boolean bl = result.getArguments().add((Object)this.utilExpressionConverter.convert((Expression)obj));
        });
        if (enDecl.getAnonymousClassDeclaration() != null) {
            result.setAnonymousClass(this.toAnonymousClassConverter.convert(enDecl.getAnonymousClassDeclaration()));
        }
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)enDecl);
        return result;
    }
}

