/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToEnumConverter
implements Converter<EnumDeclaration, Enumeration> {
    private final JdtResolver iUtilJdtResolver;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<EnumConstantDeclaration, EnumConstant> toEnumConstantConverter;
    private final Converter<BodyDeclaration, Member> toClassMemberConverter;

    @Inject
    public ToEnumConverter(JdtResolver iUtilJdtResolver, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<EnumConstantDeclaration, EnumConstant> toEnumConstantConverter, @Named(value="ToClassMemberConverter") Converter<BodyDeclaration, Member> toClassMemberConverter) {
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toEnumConstantConverter = toEnumConstantConverter;
        this.toClassMemberConverter = toClassMemberConverter;
    }

    @Override
    public Enumeration convert(EnumDeclaration enumDecl) {
        Enumeration result = this.iUtilJdtResolver.getEnumeration(enumDecl.resolveBinding());
        enumDecl.superInterfaceTypes().forEach(obj -> {
            boolean bl = result.getImplements().add((Object)this.toTypeReferenceConverter.convert((Type)obj));
        });
        enumDecl.enumConstants().forEach(obj -> {
            boolean bl = result.getConstants().add((Object)this.toEnumConstantConverter.convert((EnumConstantDeclaration)obj));
        });
        enumDecl.bodyDeclarations().forEach(obj -> {
            boolean bl = result.getMembers().add((Object)this.toClassMemberConverter.convert((BodyDeclaration)obj));
        });
        return result;
    }
}

