/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.EqualityExpression;
import tools.mdsd.jamopp.model.java.expressions.EqualityExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.operators.EqualityOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToEqualityExpressionConverter
implements Converter<InfixExpression, EqualityExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<InfixExpression.Operator, EqualityOperator> toEqualityOperatorConverter;

    @Inject
    public ToEqualityExpressionConverter(Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, Converter<InfixExpression.Operator, EqualityOperator> toEqualityOperatorConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.expressionsFactory = expressionsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.toEqualityOperatorConverter = toEqualityOperatorConverter;
    }

    @Override
    public EqualityExpression convert(InfixExpression expr) {
        EqualityExpression result = this.expressionsFactory.createEqualityExpression();
        this.mergeEqualityExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getLeftOperand()));
        result.getEqualityOperators().add((Object)this.toEqualityOperatorConverter.convert(expr.getOperator()));
        this.mergeEqualityExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getRightOperand()));
        expr.extendedOperands().forEach(obj -> {
            result.getEqualityOperators().add((Object)this.toEqualityOperatorConverter.convert(expr.getOperator()));
            this.mergeEqualityExpressionAndExpression(result, this.toExpressionConverter.convert((Expression)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private void mergeEqualityExpressionAndExpression(EqualityExpression eqExpr, tools.mdsd.jamopp.model.java.expressions.Expression potChild) {
        if (potChild instanceof EqualityExpressionChild) {
            eqExpr.getChildren().add((Object)((EqualityExpressionChild)potChild));
        } else {
            EqualityExpression expr = (EqualityExpression)potChild;
            eqExpr.getChildren().addAll((Collection)expr.getChildren());
            eqExpr.getEqualityOperators().addAll((Collection)expr.getEqualityOperators());
        }
    }
}

