/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToFieldConverter
implements Converter<FieldDeclaration, Field> {
    private final JdtResolver iUtilJdtResolver;
    private final UtilNamedElement utilNamedElement;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final UtilTypeInstructionSeparation toInstructionSeparation;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<VariableDeclarationFragment, AdditionalField> toAdditionalFieldConverter;

    @Inject
    public ToFieldConverter(UtilNamedElement utilNamedElement, UtilLayout utilLayout, JdtResolver iUtilJdtResolver, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, UtilTypeInstructionSeparation toInstructionSeparation, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, Converter<VariableDeclarationFragment, AdditionalField> toAdditionalFieldConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.utilNamedElement = utilNamedElement;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toInstructionSeparation = toInstructionSeparation;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.toAdditionalFieldConverter = toAdditionalFieldConverter;
        this.utilLayout = utilLayout;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public Field convert(FieldDeclaration fieldDecl) {
        VariableDeclarationFragment firstFragment = (VariableDeclarationFragment)fieldDecl.fragments().get(0);
        IVariableBinding binding = firstFragment.resolveBinding();
        Field result = binding != null ? this.iUtilJdtResolver.getField(binding) : this.iUtilJdtResolver.getField(firstFragment.getName().getIdentifier());
        this.utilNamedElement.setNameOfElement((Name)firstFragment.getName(), (NamedElement)result);
        fieldDecl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        result.setTypeReference(this.toTypeReferenceConverter.convert(fieldDecl.getType()));
        this.utilToArrayDimensionsAndSetConverter.convert(fieldDecl.getType(), (ArrayTypeable)result);
        firstFragment.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)result));
        if (firstFragment.getInitializer() != null) {
            this.toInstructionSeparation.addField(firstFragment.getInitializer(), result);
        }
        int index = 1;
        while (index < fieldDecl.fragments().size()) {
            result.getAdditionalFields().add((Object)this.toAdditionalFieldConverter.convert((VariableDeclarationFragment)fieldDecl.fragments().get(index)));
            ++index;
        }
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)fieldDecl);
        return result;
    }
}

