/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToInterfaceMethodConverter
implements Converter<AnnotationTypeMemberDeclaration, InterfaceMethod> {
    private final StatementsFactory statementsFactory;
    private final JdtResolver iUtilJdtResolver;
    private final UtilNamedElement utilNamedElement;
    private final UtilTypeInstructionSeparation utilTypeInstructionSeparation;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public ToInterfaceMethodConverter(UtilTypeInstructionSeparation utilTypeInstructionSeparation, UtilNamedElement utilNamedElement, UtilLayout utilLayout, JdtResolver iUtilJdtResolver, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, StatementsFactory statementsFactory, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.statementsFactory = statementsFactory;
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.utilNamedElement = utilNamedElement;
        this.utilTypeInstructionSeparation = utilTypeInstructionSeparation;
        this.utilLayout = utilLayout;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public InterfaceMethod convert(AnnotationTypeMemberDeclaration annDecl) {
        IMethodBinding binding = annDecl.resolveBinding();
        InterfaceMethod result = binding != null ? this.iUtilJdtResolver.getInterfaceMethod(binding) : this.iUtilJdtResolver.getInterfaceMethod(annDecl.getName().getIdentifier());
        annDecl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        result.setTypeReference(this.toTypeReferenceConverter.convert(annDecl.getType()));
        this.utilToArrayDimensionsAndSetConverter.convert(annDecl.getType(), (ArrayTypeable)result);
        this.utilNamedElement.setNameOfElement((Name)annDecl.getName(), (NamedElement)result);
        if (annDecl.getDefault() != null) {
            this.utilTypeInstructionSeparation.addAnnotationMethod(annDecl.getDefault(), result);
        }
        result.setStatement((Statement)this.statementsFactory.createEmptyStatement());
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)annDecl);
        return result;
    }
}

