/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToLocalVariableConverter
implements Converter<VariableDeclarationExpression, LocalVariable> {
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<VariableDeclarationFragment, AdditionalLocalVariable> toAdditionalLocalVariableConverter;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility;

    @Inject
    public ToLocalVariableConverter(UtilNamedElement utilNamedElement, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility, Converter<VariableDeclarationFragment, AdditionalLocalVariable> toAdditionalLocalVariableConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.expressionConverterUtility = expressionConverterUtility;
        this.utilNamedElement = utilNamedElement;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toAdditionalLocalVariableConverter = toAdditionalLocalVariableConverter;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public LocalVariable convert(VariableDeclarationExpression expr) {
        VariableDeclarationFragment frag = (VariableDeclarationFragment)expr.fragments().get(0);
        IVariableBinding binding = frag.resolveBinding();
        LocalVariable loc = binding == null ? this.jdtResolverUtility.getLocalVariable(String.valueOf(frag.getName().getIdentifier()) + "-" + frag.hashCode()) : this.jdtResolverUtility.getLocalVariable(binding);
        this.utilNamedElement.setNameOfElement((Name)frag.getName(), (NamedElement)loc);
        expr.modifiers().forEach(obj -> {
            boolean bl = loc.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        loc.setTypeReference(this.toTypeReferenceConverter.convert(expr.getType()));
        this.utilToArrayDimensionsAndSetConverter.convert(expr.getType(), (ArrayTypeable)loc);
        frag.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)loc));
        if (frag.getInitializer() != null) {
            loc.setInitialValue(this.expressionConverterUtility.convert(frag.getInitializer()));
        }
        int index = 1;
        while (index < expr.fragments().size()) {
            loc.getAdditionalLocalVariables().add((Object)this.toAdditionalLocalVariableConverter.convert((VariableDeclarationFragment)expr.fragments().get(index)));
            ++index;
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)loc, (ASTNode)expr);
        return loc;
    }
}

