/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ArrayConstructorReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.ClassTypeConstructorReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.MethodReferenceExpression;
import tools.mdsd.jamopp.model.java.expressions.MethodReferenceExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpressionReferenceExpression;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.Self;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilReferenceWalker;

public class ToMethodReferenceExpressionConverter
implements Converter<MethodReference, MethodReferenceExpression> {
    private final LiteralsFactory literalsFactory;
    private final ReferencesFactory referencesFactory;
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilReferenceWalker utilReferenceWalker;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Reference> toReferenceConverterFromExpression;
    private final Converter<Type, Reference> toReferenceConverterFromType;
    private final Converter<Type, TypeArgument> typeToTypeArgumentConverter;

    @Inject
    public ToMethodReferenceExpressionConverter(Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter, UtilLayout layoutInformationConverter, Converter<Type, TypeReference> toTypeReferenceConverter, ExpressionsFactory expressionsFactory, ReferencesFactory referencesFactory, LiteralsFactory literalsFactory, Converter<Type, Reference> toReferenceConverterFromType, Converter<org.eclipse.jdt.core.dom.Expression, Reference> toReferenceConverterFromExpression, Converter<Type, TypeArgument> typeToTypeArgumentConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter, UtilReferenceWalker utilReferenceWalker) {
        this.literalsFactory = literalsFactory;
        this.referencesFactory = referencesFactory;
        this.expressionsFactory = expressionsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilReferenceWalker = utilReferenceWalker;
        this.toExpressionConverter = toExpressionConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toReferenceConverterFromExpression = toReferenceConverterFromExpression;
        this.toReferenceConverterFromType = toReferenceConverterFromType;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
        this.typeToTypeArgumentConverter = typeToTypeArgumentConverter;
    }

    @Override
    public MethodReferenceExpression convert(MethodReference ref) {
        MethodReferenceExpression expression;
        if (ref.getNodeType() == 89) {
            expression = this.handleCreationReference(ref);
        } else {
            PrimaryExpressionReferenceExpression result = this.expressionsFactory.createPrimaryExpressionReferenceExpression();
            if (ref.getNodeType() == 92) {
                this.handleTypeMethodReference(ref, result);
            } else if (ref.getNodeType() == 91) {
                this.handleSuperMethodReference(ref, result);
            } else if (ref.getNodeType() == 90) {
                this.handleExpressionMethodReference(ref, result);
            }
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)ref);
            expression = result;
        }
        return expression;
    }

    private MethodReferenceExpression handleCreationReference(MethodReference ref) {
        ArrayConstructorReferenceExpression expression;
        CreationReference crRef = (CreationReference)ref;
        if (crRef.getType().isArrayType()) {
            ArrayConstructorReferenceExpression result = this.expressionsFactory.createArrayConstructorReferenceExpression();
            result.setTypeReference(this.toTypeReferenceConverter.convert(crRef.getType()));
            this.utilToArrayDimensionsAndSetConverter.convert(crRef.getType(), (ArrayTypeable)result);
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)crRef);
            expression = result;
        } else {
            ClassTypeConstructorReferenceExpression result = this.expressionsFactory.createClassTypeConstructorReferenceExpression();
            result.setTypeReference(this.toTypeReferenceConverter.convert(crRef.getType()));
            crRef.typeArguments().forEach(obj -> {
                boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
            });
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)crRef);
            expression = result;
        }
        return expression;
    }

    private void handleTypeMethodReference(MethodReference ref, PrimaryExpressionReferenceExpression result) {
        TypeMethodReference typeRef = (TypeMethodReference)ref;
        result.setChild((MethodReferenceExpressionChild)this.utilReferenceWalker.walkUp(this.toReferenceConverterFromType.convert(typeRef.getType())));
        typeRef.typeArguments().forEach(obj -> {
            boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
        });
        result.setMethodReference(this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert((org.eclipse.jdt.core.dom.Expression)typeRef.getName())));
    }

    private void handleExpressionMethodReference(MethodReference ref, PrimaryExpressionReferenceExpression result) {
        ExpressionMethodReference exprRef = (ExpressionMethodReference)ref;
        result.setChild((MethodReferenceExpressionChild)this.toExpressionConverter.convert(exprRef.getExpression()));
        exprRef.typeArguments().forEach(obj -> {
            boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
        });
        result.setMethodReference(this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert((org.eclipse.jdt.core.dom.Expression)exprRef.getName())));
    }

    private void handleSuperMethodReference(MethodReference ref, PrimaryExpressionReferenceExpression result) {
        SuperMethodReference superRef = (SuperMethodReference)ref;
        if (superRef.getQualifier() != null) {
            Reference child = this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert((org.eclipse.jdt.core.dom.Expression)superRef.getQualifier()));
            SelfReference lastPart = this.referencesFactory.createSelfReference();
            lastPart.setSelf((Self)this.literalsFactory.createSuper());
            Reference part = child;
            Reference next = child.getNext();
            while (next != null) {
                part = next;
                next = part.getNext();
            }
            part.setNext((Reference)lastPart);
            result.setChild((MethodReferenceExpressionChild)child);
        } else {
            SelfReference child = this.referencesFactory.createSelfReference();
            child.setSelf((Self)this.literalsFactory.createSuper());
            result.setChild((MethodReferenceExpressionChild)child);
        }
        superRef.typeArguments().forEach(obj -> {
            boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
        });
        result.setMethodReference(this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert((org.eclipse.jdt.core.dom.Expression)superRef.getName())));
    }
}

