/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Modifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.modifiers.Volatile;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToModifierConverter
implements Converter<Modifier, tools.mdsd.jamopp.model.java.modifiers.Modifier> {
    private final ModifiersFactory modifiersFactory;
    private final UtilLayout layoutInformationConverter;
    private final Map<Predicate<Modifier>, Supplier<tools.mdsd.jamopp.model.java.modifiers.Modifier>> mappings;

    @Inject
    public ToModifierConverter(UtilLayout layoutInformationConverter, ModifiersFactory modifiersFactory) {
        this.modifiersFactory = modifiersFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.mappings = new HashMap<Predicate<Modifier>, Supplier<tools.mdsd.jamopp.model.java.modifiers.Modifier>>();
        this.mappings.put(Modifier::isAbstract, () -> modifiersFactory.createAbstract());
        this.mappings.put(Modifier::isDefault, () -> modifiersFactory.createDefault());
        this.mappings.put(Modifier::isFinal, () -> modifiersFactory.createFinal());
        this.mappings.put(Modifier::isNative, () -> modifiersFactory.createNative());
        this.mappings.put(Modifier::isPrivate, () -> modifiersFactory.createPrivate());
        this.mappings.put(Modifier::isProtected, () -> modifiersFactory.createProtected());
        this.mappings.put(Modifier::isPublic, () -> modifiersFactory.createPublic());
        this.mappings.put(Modifier::isStatic, () -> modifiersFactory.createStatic());
        this.mappings.put(Modifier::isStrictfp, () -> modifiersFactory.createStrictfp());
        this.mappings.put(Modifier::isSynchronized, () -> modifiersFactory.createSynchronized());
        this.mappings.put(Modifier::isTransient, () -> modifiersFactory.createTransient());
    }

    @Override
    public tools.mdsd.jamopp.model.java.modifiers.Modifier convert(Modifier mod) {
        Volatile result = null;
        for (Map.Entry<Predicate<Modifier>, Supplier<tools.mdsd.jamopp.model.java.modifiers.Modifier>> entry : this.mappings.entrySet()) {
            if (!entry.getKey().test(mod)) continue;
            result = entry.getValue().get();
            break;
        }
        if (result == null) {
            result = this.modifiersFactory.createVolatile();
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)mod);
        return result;
    }
}

