/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;
import tools.mdsd.jamopp.parser.interfaces.visitor.AbstractVisitor;

public class ToModuleConverter
implements Converter<ModuleDeclaration, Module> {
    private final ModifiersFactory modifiersFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtResolverUtility;
    private final AbstractVisitor visitor;
    private final Converter<Annotation, AnnotationInstance> annotationInstanceConverter;
    private final Converter<ModuleDirective, tools.mdsd.jamopp.model.java.modules.ModuleDirective> toDirectiveConverter;

    @Inject
    public ToModuleConverter(AbstractVisitor visitor, UtilNamedElement utilNamedElement, Converter<ModuleDirective, tools.mdsd.jamopp.model.java.modules.ModuleDirective> toDirectiveConverter, ModifiersFactory modifiersFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, Converter<Annotation, AnnotationInstance> annotationInstanceConverter) {
        this.modifiersFactory = modifiersFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilNamedElement = utilNamedElement;
        this.jdtResolverUtility = jdtResolverUtility;
        this.annotationInstanceConverter = annotationInstanceConverter;
        this.toDirectiveConverter = toDirectiveConverter;
        this.visitor = visitor;
    }

    @Override
    public Module convert(ModuleDeclaration node) {
        Module module = this.jdtResolverUtility.getModule(node.resolveBinding());
        if (node.isOpen()) {
            module.setOpen(this.modifiersFactory.createOpen());
        }
        this.layoutInformationConverter.convertJavaRootLayoutInformation((JavaRoot)module, (ASTNode)node, this.visitor.getSource());
        this.utilNamedElement.addNameToNameSpace(node.getName(), (NamespaceAwareElement)module);
        module.setName("");
        node.annotations().forEach(obj -> {
            boolean bl = module.getAnnotations().add((Object)this.annotationInstanceConverter.convert((Annotation)obj));
        });
        node.moduleStatements().forEach(obj -> {
            boolean bl = module.getTarget().add((Object)this.toDirectiveConverter.convert((ModuleDirective)obj));
        });
        return module;
    }
}

