/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.Name;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.containers.Module;
import tools.mdsd.jamopp.model.java.modules.ModuleReference;
import tools.mdsd.jamopp.model.java.modules.ModulesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToModuleReferenceConverter
implements Converter<Name, ModuleReference> {
    private final ModulesFactory modulesFactory;
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtResolverUtility;

    @Inject
    public ToModuleReferenceConverter(UtilNamedElement utilNamedElement, ModulesFactory modulesFactory, JdtResolver jdtResolverUtility) {
        this.modulesFactory = modulesFactory;
        this.utilNamedElement = utilNamedElement;
        this.jdtResolverUtility = jdtResolverUtility;
    }

    @Override
    public ModuleReference convert(Name name) {
        ModuleReference ref = this.modulesFactory.createModuleReference();
        Module modProxy = this.jdtResolverUtility.getModule((IModuleBinding)name.resolveBinding());
        modProxy.setName("");
        ref.setTarget(modProxy);
        this.utilNamedElement.addNameToNameSpace(name, (NamespaceAwareElement)modProxy);
        return ref;
    }
}

