/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression;
import tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpressionChild;
import tools.mdsd.jamopp.model.java.operators.MultiplicativeOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToMultiplicativeExpressionConverter
implements Converter<InfixExpression, MultiplicativeExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<InfixExpression.Operator, MultiplicativeOperator> toMultiplicativeOperatorConverter;

    @Inject
    public ToMultiplicativeExpressionConverter(Converter<InfixExpression.Operator, MultiplicativeOperator> toMultiplicativeOperatorConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.expressionsFactory = expressionsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.toMultiplicativeOperatorConverter = toMultiplicativeOperatorConverter;
    }

    @Override
    public MultiplicativeExpression convert(InfixExpression expr) {
        MultiplicativeExpression result = this.expressionsFactory.createMultiplicativeExpression();
        this.mergeMultiplicativeExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getLeftOperand()));
        result.getMultiplicativeOperators().add((Object)this.toMultiplicativeOperatorConverter.convert(expr.getOperator()));
        this.mergeMultiplicativeExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getRightOperand()));
        expr.extendedOperands().forEach(obj -> {
            result.getMultiplicativeOperators().add((Object)this.toMultiplicativeOperatorConverter.convert(expr.getOperator()));
            this.mergeMultiplicativeExpressionAndExpression(result, this.toExpressionConverter.convert((Expression)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private void mergeMultiplicativeExpressionAndExpression(MultiplicativeExpression mulExpr, tools.mdsd.jamopp.model.java.expressions.Expression potChild) {
        if (potChild instanceof MultiplicativeExpressionChild) {
            mulExpr.getChildren().add((Object)((MultiplicativeExpressionChild)potChild));
        } else {
            MultiplicativeExpression expr = (MultiplicativeExpression)potChild;
            mulExpr.getChildren().addAll((Collection)expr.getChildren());
            mulExpr.getMultiplicativeOperators().addAll((Collection)expr.getMultiplicativeOperators());
        }
    }
}

