/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportsFactory;
import tools.mdsd.jamopp.model.java.imports.StaticMemberImport;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToNonOnDemandStaticConverter
implements Converter<ImportDeclaration, Import> {
    private final ModifiersFactory modifiersFactory;
    private final ImportsFactory importsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtResolverUtility;

    @Inject
    public ToNonOnDemandStaticConverter(UtilNamedElement utilNamedElement, ModifiersFactory modifiersFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, ImportsFactory importsFactory) {
        this.modifiersFactory = modifiersFactory;
        this.importsFactory = importsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilNamedElement = utilNamedElement;
        this.jdtResolverUtility = jdtResolverUtility;
    }

    @Override
    public Import convert(ImportDeclaration importDecl) {
        StaticMemberImport convertedImport = this.importsFactory.createStaticMemberImport();
        convertedImport.setStatic(this.modifiersFactory.createStatic());
        QualifiedName qualifiedName = (QualifiedName)importDecl.getName();
        IBinding iBinding = qualifiedName.resolveBinding();
        Classifier proxyClass = null;
        if (iBinding instanceof IMethodBinding) {
            proxyMember = this.jdtResolverUtility.getMethod((IMethodBinding)iBinding);
        } else if (iBinding instanceof IVariableBinding) {
            proxyMember = this.jdtResolverUtility.getReferencableElement((IVariableBinding)iBinding);
        } else {
            if (iBinding instanceof ITypeBinding var7_8 && typeBinding.isNested()) {
                proxyMember = this.jdtResolverUtility.getClassifier((ITypeBinding)typeBinding);
                proxyClass = this.jdtResolverUtility.getClassifier(typeBinding.getDeclaringClass());
            } else {
                if (iBinding instanceof ITypeBinding var9_10) {
                    proxyClass = this.jdtResolverUtility.getClassifier((ITypeBinding)typeBinding);
                    ConcreteClassifier conCl = (ConcreteClassifier)proxyClass;
                    proxyMember = this.findProxyMember(qualifiedName, conCl);
                    if (proxyMember == null) {
                        proxyMember = this.jdtResolverUtility.getClassMethod(qualifiedName.getFullyQualifiedName());
                        proxyMember.setName(qualifiedName.getName().getIdentifier());
                        conCl.getMembers().add((Object)((Member)proxyMember));
                    }
                } else {
                    proxyMember = this.jdtResolverUtility.getField(qualifiedName.getFullyQualifiedName());
                }
            }
        }
        proxyMember.setName(qualifiedName.getName().getIdentifier());
        convertedImport.getStaticMembers().add((Object)proxyMember);
        if (proxyClass == null) {
            proxyClass = this.handleProxyClassIsNull(qualifiedName);
        }
        convertedImport.setClassifier((ConcreteClassifier)proxyClass);
        this.utilNamedElement.addNameToNameSpaceAndElement(qualifiedName.getQualifier(), (NamespaceAwareElement)convertedImport, (NamedElement)proxyClass);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedImport, (ASTNode)importDecl);
        return convertedImport;
    }

    private ReferenceableElement findProxyMember(QualifiedName qualifiedName, ConcreteClassifier conCl) {
        ReferenceableElement newProxyMember = null;
        for (Member m : conCl.getMembers()) {
            if (m instanceof Constructor || !m.getName().equals(qualifiedName.getName().getIdentifier())) continue;
            newProxyMember = (ReferenceableElement)m;
            break;
        }
        return newProxyMember;
    }

    private Classifier handleProxyClassIsNull(QualifiedName qualifiedName) {
        IBinding binding = qualifiedName.getQualifier().resolveBinding();
        Object proxyClass = binding == null || binding.isRecovered() || !(binding instanceof ITypeBinding) ? this.jdtResolverUtility.getClass(qualifiedName.getQualifier().getFullyQualifiedName()) : this.jdtResolverUtility.getClassifier((ITypeBinding)binding);
        return proxyClass;
    }
}

