/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.NumberLiteral;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.literals.BinaryIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.BinaryLongLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.DecimalLongLiteral;
import tools.mdsd.jamopp.model.java.literals.HexDoubleLiteral;
import tools.mdsd.jamopp.model.java.literals.HexFloatLiteral;
import tools.mdsd.jamopp.model.java.literals.HexIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.HexLongLiteral;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.OctalIntegerLiteral;
import tools.mdsd.jamopp.model.java.literals.OctalLongLiteral;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToNumberLiteralConverter
implements Converter<NumberLiteral, Literal> {
    private static final char DOUBLE_BACKSLASH = '\\';
    private static final String ZERO_INT = "0";
    private static final String ZERO_LONG = "0l";
    private final LiteralsFactory literalsFactory;
    private final UtilLayout layoutInformationConverter;
    private static final String HEX_PREFIX = "0x";
    private static final String BIN_PREFIX = "0b";
    private static final String OCT_PREFIX = "0";
    private static final String LONG_SUFFIX = "l";
    private static final String FLOAT_SUFFIX = "f";
    private static final String DOUBLE_SUFFIX = "d";
    private static final String DECIMAL_EXPONENT = "e";
    private static final String HEX_EXPONENT = "p";
    private static final int BIN_BASE = 2;
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int OCT_BASE = 8;
    private static final String UNDER_SCORE = "_";
    private final Map<Predicate<String>, Function<String, Literal>> mappings;

    @Inject
    public ToNumberLiteralConverter(UtilLayout layoutInformationConverter, LiteralsFactory literalsFactory) {
        this.literalsFactory = literalsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.mappings = new LinkedHashMap<Predicate<String>, Function<String, Literal>>();
    }

    @Override
    public Literal convert(NumberLiteral literal) {
        if (this.mappings.isEmpty()) {
            this.mappings.put(string -> string.startsWith(BIN_PREFIX) && string.endsWith(LONG_SUFFIX), this::handleBinaryLong);
            this.mappings.put(string -> string.startsWith(BIN_PREFIX), this::handleBinaryInteger);
            this.mappings.put(string -> string.contains(HEX_EXPONENT) && string.endsWith(FLOAT_SUFFIX), this::handleHexFloat);
            this.mappings.put(string -> string.contains(HEX_EXPONENT), this::handleHexDouble);
            this.mappings.put(string -> string.startsWith(HEX_PREFIX) && string.endsWith(LONG_SUFFIX), this::handleHexLong);
            this.mappings.put(string -> string.startsWith(HEX_PREFIX), this::handleHexInteger);
            this.mappings.put(string -> string.endsWith(FLOAT_SUFFIX), this::handleDecimalFloat);
            this.mappings.put(string -> string.contains(".") || string.contains(DECIMAL_EXPONENT) || string.endsWith(DOUBLE_SUFFIX), this::handleDecimalDouble);
            this.mappings.put(string -> ZERO_LONG.equals(string) || !string.startsWith("0") && string.endsWith(LONG_SUFFIX), this::handleDecimalLong);
            this.mappings.put(string -> "0".equals(string) || !string.startsWith("0"), this::handleDecimalInteger);
            this.mappings.put(string -> string.endsWith(LONG_SUFFIX), this::handleOctalLong);
        }
        Literal result = null;
        String string2 = this.buildString(literal);
        for (Map.Entry<Predicate<String>, Function<String, Literal>> entry : this.mappings.entrySet()) {
            if (!entry.getKey().test(string2)) continue;
            result = entry.getValue().apply(string2);
            break;
        }
        if (result == null) {
            result = this.handleOctalInteger(string2);
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)literal);
        return result;
    }

    private Literal handleOctalInteger(String string) {
        OctalIntegerLiteral lit = this.literalsFactory.createOctalIntegerLiteral();
        lit.setOctalValue(new BigInteger(string.substring("0".length()), 8));
        return lit;
    }

    private Literal handleOctalLong(String string) {
        OctalLongLiteral lit = this.literalsFactory.createOctalLongLiteral();
        lit.setOctalValue(new BigInteger(string.substring("0".length(), string.length() - LONG_SUFFIX.length()), 8));
        return lit;
    }

    private Literal handleDecimalInteger(String string) {
        DecimalIntegerLiteral lit = this.literalsFactory.createDecimalIntegerLiteral();
        lit.setDecimalValue(new BigInteger(string, 10));
        return lit;
    }

    private Literal handleDecimalLong(String string) {
        DecimalLongLiteral lit = this.literalsFactory.createDecimalLongLiteral();
        lit.setDecimalValue(new BigInteger(string.substring(0, string.length() - LONG_SUFFIX.length()), 10));
        return lit;
    }

    private Literal handleDecimalDouble(String string) {
        String newString = string;
        if (newString.endsWith(DOUBLE_SUFFIX)) {
            newString = newString.substring(0, newString.length() - DOUBLE_SUFFIX.length());
        }
        DecimalDoubleLiteral lit = this.literalsFactory.createDecimalDoubleLiteral();
        lit.setDecimalValue(Double.parseDouble(newString));
        return lit;
    }

    private Literal handleDecimalFloat(String string) {
        DecimalFloatLiteral lit = this.literalsFactory.createDecimalFloatLiteral();
        lit.setDecimalValue(Float.parseFloat(string.substring(0, string.length() - FLOAT_SUFFIX.length())));
        return lit;
    }

    private Literal handleHexInteger(String string) {
        HexIntegerLiteral lit = this.literalsFactory.createHexIntegerLiteral();
        lit.setHexValue(new BigInteger(string.substring(HEX_PREFIX.length()), 16));
        return lit;
    }

    private Literal handleHexLong(String string) {
        HexLongLiteral lit = this.literalsFactory.createHexLongLiteral();
        lit.setHexValue(new BigInteger(string.substring(HEX_PREFIX.length(), string.length() - LONG_SUFFIX.length()), 16));
        return lit;
    }

    private Literal handleHexDouble(String string) {
        String newString = string;
        if (newString.endsWith(DOUBLE_SUFFIX)) {
            newString = newString.substring(0, newString.length() - DOUBLE_SUFFIX.length());
        }
        HexDoubleLiteral lit = this.literalsFactory.createHexDoubleLiteral();
        lit.setHexValue(Double.parseDouble(newString));
        return lit;
    }

    private Literal handleHexFloat(String string) {
        HexFloatLiteral lit = this.literalsFactory.createHexFloatLiteral();
        lit.setHexValue(Float.parseFloat(string.substring(0, string.length() - FLOAT_SUFFIX.length())));
        return lit;
    }

    private Literal handleBinaryInteger(String string) {
        BinaryIntegerLiteral lit = this.literalsFactory.createBinaryIntegerLiteral();
        lit.setBinaryValue(new BigInteger(string.substring(BIN_PREFIX.length()), 2));
        return lit;
    }

    private Literal handleBinaryLong(String string) {
        BinaryLongLiteral lit = this.literalsFactory.createBinaryLongLiteral();
        lit.setBinaryValue(new BigInteger(string.substring(BIN_PREFIX.length(), string.length() - LONG_SUFFIX.length()), 2));
        return lit;
    }

    private String buildString(NumberLiteral literal) {
        String string = literal.getToken();
        if (string.contains("\\u")) {
            StringBuilder actualLiteral = new StringBuilder();
            int index = 0;
            while (index < string.length()) {
                char currentChar = string.charAt(index);
                if (currentChar == '\\') {
                    int codePoint = Integer.parseInt(string.substring(index + 2, index + 6), 16);
                    actualLiteral.append(Character.toString(codePoint));
                    index += 6;
                    continue;
                }
                actualLiteral.append(currentChar);
                ++index;
            }
            string = actualLiteral.toString();
        }
        string = string.replace(UNDER_SCORE, "");
        return string.toLowerCase(Locale.US);
    }
}

