/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.model.java.imports.Import;
import tools.mdsd.jamopp.model.java.imports.ImportsFactory;
import tools.mdsd.jamopp.model.java.imports.StaticClassifierImport;
import tools.mdsd.jamopp.model.java.modifiers.ModifiersFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToOnDemandStaticConverter
implements Converter<ImportDeclaration, Import> {
    private final ModifiersFactory modifiersFactory;
    private final ImportsFactory importsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilNamedElement utilNamedElement;
    private final JdtResolver jdtResolverUtility;

    @Inject
    public ToOnDemandStaticConverter(UtilNamedElement utilNamedElement, ModifiersFactory modifiersFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, ImportsFactory importsFactory) {
        this.modifiersFactory = modifiersFactory;
        this.importsFactory = importsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilNamedElement = utilNamedElement;
        this.jdtResolverUtility = jdtResolverUtility;
    }

    @Override
    public Import convert(ImportDeclaration importDecl) {
        StaticClassifierImport convertedImport = this.importsFactory.createStaticClassifierImport();
        convertedImport.setStatic(this.modifiersFactory.createStatic());
        IBinding binding = importDecl.getName().resolveBinding();
        Object proxyClass = binding == null || binding.isRecovered() || !(binding instanceof ITypeBinding) ? this.jdtResolverUtility.getClass(importDecl.getName().getFullyQualifiedName()) : this.jdtResolverUtility.getClassifier((ITypeBinding)binding);
        convertedImport.setClassifier((ConcreteClassifier)proxyClass);
        this.utilNamedElement.addNameToNameSpaceAndElement(importDecl.getName(), (NamespaceAwareElement)convertedImport, (NamedElement)proxyClass);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedImport, (ASTNode)importDecl);
        return convertedImport;
    }
}

