/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToOrdinaryParameterConverter
implements Converter<SingleVariableDeclaration, OrdinaryParameter> {
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public ToOrdinaryParameterConverter(UtilNamedElement utilNamedElement, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilNamedElement = utilNamedElement;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public OrdinaryParameter convert(SingleVariableDeclaration decl) {
        OrdinaryParameter result = this.jdtResolverUtility.getOrdinaryParameter(decl.resolveBinding());
        decl.modifiers().forEach(obj -> {
            boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        result.setTypeReference(this.toTypeReferenceConverter.convert(decl.getType()));
        this.utilToArrayDimensionsAndSetConverter.convert(decl.getType(), (ArrayTypeable)result);
        this.utilNamedElement.setNameOfElement((Name)decl.getName(), (NamedElement)result);
        decl.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)result));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)decl);
        return result;
    }
}

