/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.VariableLengthParameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToParameterConverter
implements Converter<SingleVariableDeclaration, Parameter> {
    private final JdtResolver utilJDTResolver;
    private final UtilNamedElement utilNamedElement;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter;
    private final Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public ToParameterConverter(UtilNamedElement utilNamedElement, UtilLayout utilLayout, JdtResolver utilJDTResolver, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter, Converter<IExtendedModifier, AnnotationInstanceOrModifier> toModifierOrAnnotationInstanceConverter, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.utilJDTResolver = utilJDTResolver;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.utilNamedElement = utilNamedElement;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.utilLayout = utilLayout;
        this.toModifierOrAnnotationInstanceConverter = toModifierOrAnnotationInstanceConverter;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.toOrdinaryParameterConverter = toOrdinaryParameterConverter;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public Parameter convert(SingleVariableDeclaration decl) {
        Parameter parameter;
        if (decl.isVarargs()) {
            VariableLengthParameter result = this.utilJDTResolver.getVariableLengthParameter(decl.resolveBinding());
            decl.modifiers().forEach(obj -> {
                boolean bl = result.getAnnotationsAndModifiers().add((Object)this.toModifierOrAnnotationInstanceConverter.convert((IExtendedModifier)obj));
            });
            result.setTypeReference(this.toTypeReferenceConverter.convert(decl.getType()));
            this.utilToArrayDimensionsAndSetConverter.convert(decl.getType(), (ArrayTypeable)result);
            this.utilNamedElement.setNameOfElement((Name)decl.getName(), (NamedElement)result);
            decl.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)result));
            decl.varargsAnnotations().forEach(obj -> {
                boolean bl = result.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
            });
            this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)decl);
            parameter = result;
        } else {
            parameter = (Parameter)this.toOrdinaryParameterConverter.convert(decl);
        }
        return parameter;
    }
}

