/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.PrimaryExpression;
import tools.mdsd.jamopp.model.java.literals.BooleanLiteral;
import tools.mdsd.jamopp.model.java.literals.Literal;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.NullLiteral;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilReferenceWalker;

public class ToPrimaryExpressionConverter
implements Converter<Expression, PrimaryExpression> {
    private final LiteralsFactory literalsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilReferenceWalker utilReferenceWalker;
    private final Converter<NumberLiteral, Literal> toNumberLiteralConverter;
    private final Converter<Expression, Reference> toReferenceConverterFromExpression;

    @Inject
    public ToPrimaryExpressionConverter(LiteralsFactory literalsFactory, Converter<NumberLiteral, Literal> toNumberLiteralConverter, UtilLayout layoutInformationConverter, Converter<Expression, Reference> toReferenceConverterFromExpression, UtilReferenceWalker utilReferenceWalker) {
        this.utilReferenceWalker = utilReferenceWalker;
        this.toNumberLiteralConverter = toNumberLiteralConverter;
        this.layoutInformationConverter = layoutInformationConverter;
        this.literalsFactory = literalsFactory;
        this.toReferenceConverterFromExpression = toReferenceConverterFromExpression;
    }

    @Override
    public PrimaryExpression convert(Expression expr) {
        Object result = expr.getNodeType() == 9 ? this.createBooleanLiteral(expr) : (expr.getNodeType() == 33 ? this.createNullLiteral(expr) : (expr.getNodeType() == 13 ? this.createCharacterLiteral(expr) : (expr.getNodeType() == 34 ? (PrimaryExpression)this.toNumberLiteralConverter.convert((NumberLiteral)expr) : this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert(expr)))));
        return result;
    }

    private PrimaryExpression createCharacterLiteral(Expression expr) {
        CharacterLiteral lit = (CharacterLiteral)expr;
        tools.mdsd.jamopp.model.java.literals.CharacterLiteral result = this.literalsFactory.createCharacterLiteral();
        result.setValue(lit.getEscapedValue().substring(1, lit.getEscapedValue().length() - 1));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)lit);
        return result;
    }

    private PrimaryExpression createNullLiteral(Expression expr) {
        NullLiteral result = this.literalsFactory.createNullLiteral();
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private BooleanLiteral createBooleanLiteral(Expression expr) {
        org.eclipse.jdt.core.dom.BooleanLiteral lit = (org.eclipse.jdt.core.dom.BooleanLiteral)expr;
        BooleanLiteral result = this.literalsFactory.createBooleanLiteral();
        result.setValue(lit.booleanValue());
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)lit);
        return result;
    }
}

