/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationBySize;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesTyped;
import tools.mdsd.jamopp.model.java.arrays.ArrayInstantiationByValuesUntyped;
import tools.mdsd.jamopp.model.java.arrays.ArraySelector;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.arrays.ArraysFactory;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.NestedExpression;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.instantiations.InstantiationsFactory;
import tools.mdsd.jamopp.model.java.instantiations.NewConstructorCall;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.Self;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.references.ReflectiveClassReference;
import tools.mdsd.jamopp.model.java.references.SelfReference;
import tools.mdsd.jamopp.model.java.references.StringReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToReferenceConverterFromExpression
implements Converter<org.eclipse.jdt.core.dom.Expression, Reference> {
    private ExpressionsFactory expressionsFactory;
    private LiteralsFactory literalsFactory;
    private ReferencesFactory referencesFactory;
    private InstantiationsFactory instantiationsFactory;
    private ArraysFactory arraysFactory;
    private ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private UtilLayout layoutInformationConverter;
    private JdtResolver jdtResolverUtility;
    private UtilNamedElement utilNamedElement;
    private Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility;
    private Converter<Type, TypeReference> toTypeReferenceConverter;
    private Converter<ArrayInitializer, tools.mdsd.jamopp.model.java.arrays.ArrayInitializer> toArrayInitialisierConverter;
    private Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private Converter<AnonymousClassDeclaration, AnonymousClass> toAnonymousClassConverter;
    private Converter<SimpleName, IdentifierReference> toReferenceConverterFromName;
    private Converter<MethodInvocation, MethodCall> toReferenceConverterFromMethodInvocation;
    private Converter<Type, Reference> toReferenceConverterFromType;
    private Converter<Type, TypeArgument> typeToTypeArgumentConverter;
    private final Map<Integer, Function<org.eclipse.jdt.core.dom.Expression, Reference>> mappings = new HashMap<Integer, Function<org.eclipse.jdt.core.dom.Expression, Reference>>();

    public ToReferenceConverterFromExpression() {
        this.mappings.put(2, this::handleArrayAcces);
        this.mappings.put(3, this::handleArrayCreation);
        this.mappings.put(4, this::handleArrayInitiliazer);
        this.mappings.put(14, this::handleClassInstanceCreation);
        this.mappings.put(22, this::handleFieldAcces);
        this.mappings.put(32, expr -> (Reference)this.toReferenceConverterFromMethodInvocation.convert((MethodInvocation)expr));
        this.mappings.put(40, this::handleQualifiedName);
        this.mappings.put(42, this::handleSimpleName);
        this.mappings.put(36, this::handleParanthesizedExpression);
        this.mappings.put(45, this::handleStringLiteral);
        this.mappings.put(47, this::handleSuperFieldAcces);
        this.mappings.put(48, this::handleSuperMethodInvocation);
        this.mappings.put(52, this::handleThisExpression);
        this.mappings.put(57, this::handleTypeLiteral);
    }

    @Inject
    public void setMembers(UtilNamedElement utilNamedElement, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<Type, Reference> toReferenceConverterFromType, Converter<SimpleName, IdentifierReference> toReferenceConverterFromName, Converter<MethodInvocation, MethodCall> toReferenceConverterFromMethodInvocation, Converter<ArrayInitializer, tools.mdsd.jamopp.model.java.arrays.ArrayInitializer> toArrayInitialisierConverter, Converter<AnonymousClassDeclaration, AnonymousClass> toAnonymousClassConverter, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter, ReferencesFactory referencesFactory, LiteralsFactory literalsFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, InstantiationsFactory instantiationsFactory, ExpressionsFactory expressionsFactory, Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility, ArraysFactory arraysFactory, Converter<Type, TypeArgument> typeToTypeArgumentConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.expressionsFactory = expressionsFactory;
        this.literalsFactory = literalsFactory;
        this.referencesFactory = referencesFactory;
        this.instantiationsFactory = instantiationsFactory;
        this.arraysFactory = arraysFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.expressionConverterUtility = expressionConverterUtility;
        this.utilNamedElement = utilNamedElement;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toArrayInitialisierConverter = toArrayInitialisierConverter;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.toAnonymousClassConverter = toAnonymousClassConverter;
        this.toReferenceConverterFromName = toReferenceConverterFromName;
        this.toReferenceConverterFromMethodInvocation = toReferenceConverterFromMethodInvocation;
        this.toReferenceConverterFromType = toReferenceConverterFromType;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
        this.typeToTypeArgumentConverter = typeToTypeArgumentConverter;
    }

    @Override
    public Reference convert(org.eclipse.jdt.core.dom.Expression expression) {
        Reference result = null;
        if (expression instanceof Annotation) {
            result = (Reference)this.toAnnotationInstanceConverter.convert((Annotation)expression);
        } else {
            for (Map.Entry<Integer, Function<org.eclipse.jdt.core.dom.Expression, Reference>> entry : this.mappings.entrySet()) {
                if (expression.getNodeType() != entry.getKey().intValue()) continue;
                result = entry.getValue().apply(expression);
                break;
            }
        }
        return result;
    }

    private Reference handleTypeLiteral(org.eclipse.jdt.core.dom.Expression expr) {
        TypeLiteral arr = (TypeLiteral)expr;
        ReflectiveClassReference result = this.referencesFactory.createReflectiveClassReference();
        Reference parent = this.toReferenceConverterFromType.convert(arr.getType());
        parent.setNext((Reference)result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handleThisExpression(org.eclipse.jdt.core.dom.Expression expr) {
        ThisExpression arr = (ThisExpression)expr;
        SelfReference result = this.referencesFactory.createSelfReference();
        result.setSelf((Self)this.literalsFactory.createThis());
        if (arr.getQualifier() != null) {
            Reference parent = this.convert((org.eclipse.jdt.core.dom.Expression)arr.getQualifier());
            parent.setNext((Reference)result);
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handleSuperMethodInvocation(org.eclipse.jdt.core.dom.Expression expr) {
        ClassMethod proxy;
        SuperMethodInvocation arr = (SuperMethodInvocation)expr;
        SelfReference partOne = this.referencesFactory.createSelfReference();
        partOne.setSelf((Self)this.literalsFactory.createSuper());
        if (arr.getQualifier() != null) {
            Reference parent = this.convert((org.eclipse.jdt.core.dom.Expression)arr.getQualifier());
            parent.setNext((Reference)partOne);
        }
        MethodCall partTwo = this.referencesFactory.createMethodCall();
        arr.typeArguments().forEach(obj -> {
            boolean bl = partTwo.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
        });
        arr.arguments().forEach(obj -> {
            boolean bl = partTwo.getArguments().add((Object)this.expressionConverterUtility.convert((org.eclipse.jdt.core.dom.Expression)obj));
        });
        if (arr.getName().resolveBinding() != null) {
            proxy = this.jdtResolverUtility.getMethod((IMethodBinding)arr.getName().resolveBinding());
        } else {
            proxy = this.jdtResolverUtility.getClassMethod(arr.getName().getIdentifier());
            proxy.setName(arr.getName().getIdentifier());
        }
        this.utilNamedElement.setNameOfElement((Name)arr.getName(), (NamedElement)proxy);
        partTwo.setTarget((ReferenceableElement)proxy);
        partOne.setNext((Reference)partTwo);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)partTwo, (ASTNode)arr);
        return partTwo;
    }

    private Reference handleSuperFieldAcces(org.eclipse.jdt.core.dom.Expression expr) {
        SuperFieldAccess arr = (SuperFieldAccess)expr;
        SelfReference partOne = this.referencesFactory.createSelfReference();
        partOne.setSelf((Self)this.literalsFactory.createSuper());
        if (arr.getQualifier() != null) {
            Reference parent = this.convert((org.eclipse.jdt.core.dom.Expression)arr.getQualifier());
            parent.setNext((Reference)partOne);
        }
        IdentifierReference partTwo = this.toReferenceConverterFromName.convert(arr.getName());
        partOne.setNext((Reference)partTwo);
        return partTwo;
    }

    private Reference handleStringLiteral(org.eclipse.jdt.core.dom.Expression expr) {
        StringLiteral arr = (StringLiteral)expr;
        StringReference result = this.referencesFactory.createStringReference();
        result.setValue(arr.getEscapedValue().substring(1, arr.getEscapedValue().length() - 1));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handleParanthesizedExpression(org.eclipse.jdt.core.dom.Expression expr) {
        ParenthesizedExpression arr = (ParenthesizedExpression)expr;
        NestedExpression result = this.expressionsFactory.createNestedExpression();
        result.setExpression(this.expressionConverterUtility.convert(arr.getExpression()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handleSimpleName(org.eclipse.jdt.core.dom.Expression expr) {
        return (Reference)this.toReferenceConverterFromName.convert((SimpleName)expr);
    }

    private Reference handleQualifiedName(org.eclipse.jdt.core.dom.Expression expr) {
        QualifiedName arr = (QualifiedName)expr;
        IdentifierReference result = this.toReferenceConverterFromName.convert(arr.getName());
        Reference parent = this.convert((org.eclipse.jdt.core.dom.Expression)arr.getQualifier());
        parent.setNext((Reference)result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handleFieldAcces(org.eclipse.jdt.core.dom.Expression expr) {
        FieldAccess arr = (FieldAccess)expr;
        Reference parent = this.convert(arr.getExpression());
        IdentifierReference result = this.toReferenceConverterFromName.convert(arr.getName());
        parent.setNext((Reference)result);
        return result;
    }

    private Reference handleClassInstanceCreation(org.eclipse.jdt.core.dom.Expression expr) {
        ClassInstanceCreation arr = (ClassInstanceCreation)expr;
        Object result = arr.getType().isParameterizedType() && ((ParameterizedType)arr.getType()).typeArguments().isEmpty() ? this.instantiationsFactory.createNewConstructorCallWithInferredTypeArguments() : this.instantiationsFactory.createNewConstructorCall();
        arr.typeArguments().forEach(arg_0 -> this.lambda$16((NewConstructorCall)result, arg_0));
        result.setTypeReference(this.toTypeReferenceConverter.convert(arr.getType()));
        arr.arguments().forEach(arg_0 -> this.lambda$17((NewConstructorCall)result, arg_0));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        if (arr.getAnonymousClassDeclaration() != null) {
            result.setAnonymousClass(this.toAnonymousClassConverter.convert(arr.getAnonymousClassDeclaration()));
        }
        if (arr.getExpression() != null) {
            Reference parent = this.convert(arr.getExpression());
            parent.setNext((Reference)result);
        }
        return result;
    }

    private Reference handleArrayInitiliazer(org.eclipse.jdt.core.dom.Expression expr) {
        ArrayInstantiationByValuesUntyped result = this.arraysFactory.createArrayInstantiationByValuesUntyped();
        result.setArrayInitializer(this.toArrayInitialisierConverter.convert((ArrayInitializer)expr));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private Reference handleArrayCreation(org.eclipse.jdt.core.dom.Expression expr) {
        ArrayInstantiationByValuesTyped reference;
        ArrayCreation arr = (ArrayCreation)expr;
        if (arr.getInitializer() != null) {
            ArrayInstantiationByValuesTyped result = this.arraysFactory.createArrayInstantiationByValuesTyped();
            result.setTypeReference(this.toTypeReferenceConverter.convert((Type)arr.getType()));
            this.utilToArrayDimensionsAndSetConverter.convert((Type)arr.getType(), (ArrayTypeable)result);
            result.setArrayInitializer(this.toArrayInitialisierConverter.convert(arr.getInitializer()));
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
            reference = result;
        } else {
            ArrayInstantiationBySize result = this.arraysFactory.createArrayInstantiationBySize();
            result.setTypeReference(this.toTypeReferenceConverter.convert((Type)arr.getType()));
            this.utilToArrayDimensionsAndSetConverter.convert((Type)arr.getType(), (ArrayTypeable)result, arr.dimensions().size());
            arr.dimensions().forEach(obj -> {
                boolean bl = result.getSizes().add((Object)this.expressionConverterUtility.convert((org.eclipse.jdt.core.dom.Expression)obj));
            });
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
            reference = result;
        }
        return reference;
    }

    private Reference handleArrayAcces(org.eclipse.jdt.core.dom.Expression expr) {
        ArrayAccess arr = (ArrayAccess)expr;
        Reference parent = this.convert(arr.getArray());
        ArraySelector selector = this.arraysFactory.createArraySelector();
        selector.setPosition(this.expressionConverterUtility.convert(arr.getIndex()));
        parent.getArraySelectors().add((Object)selector);
        return parent;
    }

    private /* synthetic */ void lambda$16(NewConstructorCall newConstructorCall, Object obj) {
        boolean bl = newConstructorCall.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
    }

    private /* synthetic */ void lambda$17(NewConstructorCall newConstructorCall, Object obj) {
        boolean bl = newConstructorCall.getArguments().add((Object)this.expressionConverterUtility.convert((org.eclipse.jdt.core.dom.Expression)obj));
    }
}

