/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToReferenceConverterFromMethodInvocation
implements Converter<MethodInvocation, MethodCall> {
    private final ReferencesFactory referencesFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<Expression, Reference> toReferenceConverterFromExpression;
    private final Converter<Type, TypeArgument> typeToTypeArgumentConverter;

    @Inject
    public ToReferenceConverterFromMethodInvocation(UtilNamedElement utilNamedElement, ReferencesFactory referencesFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility, Converter<Expression, Reference> toReferenceConverterFromExpression, Converter<Type, TypeArgument> typeToTypeArgumentConverter) {
        this.referencesFactory = referencesFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.expressionConverterUtility = expressionConverterUtility;
        this.utilNamedElement = utilNamedElement;
        this.toReferenceConverterFromExpression = toReferenceConverterFromExpression;
        this.typeToTypeArgumentConverter = typeToTypeArgumentConverter;
    }

    @Override
    public MethodCall convert(MethodInvocation arr) {
        Method methodProxy;
        Reference parent = null;
        if (arr.getExpression() != null) {
            parent = this.toReferenceConverterFromExpression.convert(arr.getExpression());
        }
        MethodCall result = this.referencesFactory.createMethodCall();
        arr.typeArguments().forEach(obj -> {
            boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
        });
        arr.arguments().forEach(obj -> {
            boolean bl = result.getArguments().add((Object)this.expressionConverterUtility.convert((Expression)obj));
        });
        IMethodBinding methBind = arr.resolveMethodBinding();
        if (methBind != null) {
            methodProxy = this.jdtResolverUtility.getMethod(methBind);
        } else {
            methodProxy = this.jdtResolverUtility.getClassMethod(arr.getName().getIdentifier());
            methodProxy.setName(arr.getName().getIdentifier());
        }
        this.utilNamedElement.setNameOfElement((Name)arr.getName(), (NamedElement)methodProxy);
        result.setTarget((ReferenceableElement)methodProxy);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        if (parent != null) {
            parent.setNext((Reference)result);
        }
        return result;
    }
}

