/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.ReferenceableElement;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToReferenceConverterFromSimpleName
implements Converter<SimpleName, IdentifierReference> {
    private final ReferencesFactory referencesFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;

    @Inject
    public ToReferenceConverterFromSimpleName(ReferencesFactory referencesFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility) {
        this.referencesFactory = referencesFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
    }

    @Override
    public IdentifierReference convert(SimpleName name) {
        IdentifierReference result = this.referencesFactory.createIdentifierReference();
        IBinding binding = name.resolveBinding();
        Object target = binding instanceof ITypeBinding ? this.jdtResolverUtility.getClassifier((ITypeBinding)binding) : (binding instanceof IVariableBinding ? this.jdtResolverUtility.getReferencableElement((IVariableBinding)binding) : (binding instanceof IMethodBinding ? this.jdtResolverUtility.getMethod((IMethodBinding)binding) : (binding instanceof IPackageBinding ? this.jdtResolverUtility.getPackage((IPackageBinding)binding) : this.jdtResolverUtility.getReferenceableElementByNameMatching(name.getIdentifier()))));
        target.setName(name.getIdentifier());
        result.setTarget((ReferenceableElement)target);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)name);
        return result;
    }
}

