/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.instantiations.ExplicitConstructorCall;
import tools.mdsd.jamopp.model.java.instantiations.InstantiationsFactory;
import tools.mdsd.jamopp.model.java.literals.LiteralsFactory;
import tools.mdsd.jamopp.model.java.literals.Self;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToReferenceConverterFromStatement
implements Converter<Statement, Reference> {
    private final LiteralsFactory literalsFactory;
    private final InstantiationsFactory instantiationsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<Expression, Reference> toReferenceConverterFromExpression;
    private final Converter<Type, TypeArgument> typeToTypeArgumentConverter;

    @Inject
    public ToReferenceConverterFromStatement(LiteralsFactory literalsFactory, UtilLayout layoutInformationConverter, InstantiationsFactory instantiationsFactory, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility, Converter<Expression, Reference> toReferenceConverterFromExpression, Converter<Type, TypeArgument> typeToTypeArgumentConverter) {
        this.literalsFactory = literalsFactory;
        this.instantiationsFactory = instantiationsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toReferenceConverterFromExpression = toReferenceConverterFromExpression;
        this.typeToTypeArgumentConverter = typeToTypeArgumentConverter;
    }

    @Override
    public Reference convert(Statement statement) {
        ExplicitConstructorCall reference = null;
        if (statement.getNodeType() == 17) {
            ConstructorInvocation invoc = (ConstructorInvocation)statement;
            ExplicitConstructorCall result = this.instantiationsFactory.createExplicitConstructorCall();
            invoc.typeArguments().forEach(obj -> {
                boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
            });
            result.setCallTarget((Self)this.literalsFactory.createThis());
            invoc.arguments().forEach(obj -> {
                boolean bl = result.getArguments().add((Object)this.expressionConverterUtility.convert((Expression)obj));
            });
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)invoc);
            reference = result;
        } else if (statement.getNodeType() == 46) {
            SuperConstructorInvocation invoc = (SuperConstructorInvocation)statement;
            ExplicitConstructorCall result = this.instantiationsFactory.createExplicitConstructorCall();
            invoc.typeArguments().forEach(obj -> {
                boolean bl = result.getCallTypeArguments().add((Object)this.typeToTypeArgumentConverter.convert((Type)obj));
            });
            result.setCallTarget((Self)this.literalsFactory.createSuper());
            invoc.arguments().forEach(obj -> {
                boolean bl = result.getArguments().add((Object)this.expressionConverterUtility.convert((Expression)obj));
            });
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)invoc);
            if (invoc.getExpression() != null) {
                Reference parent = this.toReferenceConverterFromExpression.convert(invoc.getExpression());
                parent.setNext((Reference)result);
            }
            reference = result;
        }
        return reference;
    }
}

