/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.references.IdentifierReference;
import tools.mdsd.jamopp.model.java.references.PrimitiveTypeReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.references.ReferencesFactory;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToReferenceConverterFromType
implements Converter<Type, Reference> {
    private final ReferencesFactory referencesFactory;
    private final UtilLayout layoutInformationConverter;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private final Converter<Name, IdentifierReference> toReferenceConverterFromName;
    private final Converter<SimpleName, IdentifierReference> toReferenceConverterFromSimpleName;

    @Inject
    public ToReferenceConverterFromType(Converter<Type, TypeReference> toTypeReferenceConverter, Converter<Name, IdentifierReference> toReferenceConverterFromName, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter, ReferencesFactory referencesFactory, UtilLayout layoutInformationConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter, Converter<SimpleName, IdentifierReference> toReferenceConverterFromSimpleName) {
        this.referencesFactory = referencesFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.toReferenceConverterFromName = toReferenceConverterFromName;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
        this.toReferenceConverterFromSimpleName = toReferenceConverterFromSimpleName;
    }

    @Override
    public Reference convert(Type type) {
        Reference result = null;
        if (type.isNameQualifiedType()) {
            result = this.handleNameQualifiedType(type);
        } else if (type.isQualifiedType()) {
            result = this.handleQualifiedType(type);
        } else if (type.isSimpleType()) {
            result = this.handleSimpleType(type);
        } else if (type.isPrimitiveType()) {
            result = this.handlePrimitiveType(type);
        } else if (type.isArrayType()) {
            result = this.handleArrayType(type);
        }
        return result;
    }

    private Reference handleArrayType(Type type) {
        ArrayType arr = (ArrayType)type;
        Reference result = this.convert(arr.getElementType());
        if (arr.getElementType().isPrimitiveType()) {
            PrimitiveTypeReference primRef = (PrimitiveTypeReference)result;
            this.utilToArrayDimensionsAndSetConverter.convert((Type)arr, (ArrayTypeable)primRef);
        } else {
            IdentifierReference idRef = (IdentifierReference)result;
            this.utilToArrayDimensionsAndSetConverter.convert((Type)arr, (ArrayTypeable)idRef);
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)arr);
        return result;
    }

    private Reference handlePrimitiveType(Type type) {
        TypeReference typeRef = this.toTypeReferenceConverter.convert(type);
        PrimitiveTypeReference temp = this.referencesFactory.createPrimitiveTypeReference();
        temp.setPrimitiveType((PrimitiveType)typeRef);
        temp.getLayoutInformations().addAll((Collection)typeRef.getLayoutInformations());
        return temp;
    }

    private Reference handleSimpleType(Type type) {
        SimpleType sType = (SimpleType)type;
        IdentifierReference result = this.toReferenceConverterFromName.convert(sType.getName());
        sType.annotations().forEach(obj -> {
            boolean bl = result.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)sType);
        return result;
    }

    private Reference handleQualifiedType(Type type) {
        QualifiedType qType = (QualifiedType)type;
        Reference parent = this.convert(qType.getQualifier());
        IdentifierReference child = this.toReferenceConverterFromSimpleName.convert(qType.getName());
        qType.annotations().forEach(obj -> {
            boolean bl = child.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        parent.setNext((Reference)child);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)child, (ASTNode)qType);
        return child;
    }

    private Reference handleNameQualifiedType(Type type) {
        NameQualifiedType nqType = (NameQualifiedType)type;
        IdentifierReference parent = this.toReferenceConverterFromName.convert(nqType.getQualifier());
        IdentifierReference child = this.toReferenceConverterFromSimpleName.convert(nqType.getName());
        parent.setNext((Reference)child);
        nqType.annotations().forEach(obj -> {
            boolean bl = child.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)child, (ASTNode)nqType);
        return child;
    }
}

